% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{codestar}
\alias{codestar}
\title{AWS CodeStar}
\usage{
codestar(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This is the API reference for AWS CodeStar. This reference provides
descriptions of the operations and data types for the AWS CodeStar API
along with usage examples.

You can use the AWS CodeStar API to work with:

Projects and their resources, by calling the following:
\itemize{
\item \code{delete_project}, which deletes a
project.
\item \code{describe_project}, which lists the
attributes of a project.
\item \code{list_projects}, which lists all projects
associated with your AWS account.
\item \code{list_resources}, which lists the
resources associated with a project.
\item \code{list_tags_for_project}, which
lists the tags associated with a project.
\item \code{tag_project}, which adds tags to a project.
\item \code{untag_project}, which removes tags from a
project.
\item \code{update_project}, which updates the
attributes of a project.
}

Teams and team members, by calling the following:
\itemize{
\item \code{associate_team_member}, which
adds an IAM user to the team for a project.
\item \code{disassociate_team_member},
which removes an IAM user from the team for a project.
\item \code{list_team_members}, which lists all
the IAM users in the team for a project, including their roles and
attributes.
\item \code{update_team_member}, which updates a
team member's attributes in a project.
}

Users, by calling the following:
\itemize{
\item \code{create_user_profile}, which creates
a user profile that contains data associated with the user across
all projects.
\item \code{delete_user_profile}, which deletes
all user profile information across all projects.
\item \code{describe_user_profile}, which
describes the profile of a user.
\item \code{list_user_profiles}, which lists all
user profiles.
\item \code{update_user_profile}, which updates
the profile for a user.
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codestar(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.developer.tools:codestar_associate_team_member]{associate_team_member} \tab Adds an IAM user to the team for an AWS CodeStar project\cr
\link[paws.developer.tools:codestar_create_project]{create_project} \tab Creates a project, including project resources\cr
\link[paws.developer.tools:codestar_create_user_profile]{create_user_profile} \tab Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar\cr
\link[paws.developer.tools:codestar_delete_project]{delete_project} \tab Deletes a project, including project resources\cr
\link[paws.developer.tools:codestar_delete_user_profile]{delete_user_profile} \tab Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address\cr
\link[paws.developer.tools:codestar_describe_project]{describe_project} \tab Describes a project and its resources\cr
\link[paws.developer.tools:codestar_describe_user_profile]{describe_user_profile} \tab Describes a user in AWS CodeStar and the user attributes across all projects\cr
\link[paws.developer.tools:codestar_disassociate_team_member]{disassociate_team_member} \tab Removes a user from a project\cr
\link[paws.developer.tools:codestar_list_projects]{list_projects} \tab Lists all projects in AWS CodeStar associated with your AWS account\cr
\link[paws.developer.tools:codestar_list_resources]{list_resources} \tab Lists resources associated with a project in AWS CodeStar\cr
\link[paws.developer.tools:codestar_list_tags_for_project]{list_tags_for_project} \tab Gets the tags for a project\cr
\link[paws.developer.tools:codestar_list_team_members]{list_team_members} \tab Lists all team members associated with a project\cr
\link[paws.developer.tools:codestar_list_user_profiles]{list_user_profiles} \tab Lists all the user profiles configured for your AWS account in AWS CodeStar\cr
\link[paws.developer.tools:codestar_tag_project]{tag_project} \tab Adds tags to a project\cr
\link[paws.developer.tools:codestar_untag_project]{untag_project} \tab Removes tags from a project\cr
\link[paws.developer.tools:codestar_update_project]{update_project} \tab Updates a project in AWS CodeStar\cr
\link[paws.developer.tools:codestar_update_team_member]{update_team_member} \tab Updates a team member's attributes in an AWS CodeStar project\cr
\link[paws.developer.tools:codestar_update_user_profile]{update_user_profile} \tab Updates a user's profile in AWS CodeStar
}
}

\examples{
\dontrun{
svc <- codestar()
svc$associate_team_member(
  Foo = 123
)
}

}
