% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{workmailmessageflow}
\alias{workmailmessageflow}
\title{Amazon WorkMail Message Flow}
\usage{
workmailmessageflow(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The WorkMail Message Flow API provides access to email messages as they
are being sent and received by a WorkMail organization.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- workmailmessageflow(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.end.user.computing:workmailmessageflow_get_raw_message_content]{get_raw_message_content} \tab Retrieves the raw content of an in-transit email message, in MIME format\cr
\link[paws.end.user.computing:workmailmessageflow_put_raw_message_content]{put_raw_message_content} \tab Updates the raw content of an in-transit email message, in MIME format
}
}

\examples{
\dontrun{
svc <- workmailmessageflow()
svc$get_raw_message_content(
  Foo = 123
)
}

}
