% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{applicationautoscaling}
\alias{applicationautoscaling}
\title{Application Auto Scaling}
\usage{
applicationautoscaling(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
With Application Auto Scaling, you can configure automatic scaling for
the following resources:
\itemize{
\item Amazon ECS services
\item Amazon EC2 Spot Fleet requests
\item Amazon EMR clusters
\item Amazon AppStream 2.0 fleets
\item Amazon DynamoDB tables and global secondary indexes throughput
capacity
\item Amazon Aurora Replicas
\item Amazon SageMaker endpoint variants
\item Custom resources provided by your own applications or services
\item Amazon Comprehend document classification and entity recognizer
endpoints
\item AWS Lambda function provisioned concurrency
\item Amazon Keyspaces (for Apache Cassandra) tables
\item Amazon Managed Streaming for Apache Kafka cluster storage
}

\strong{API Summary}

The Application Auto Scaling service API includes three key sets of
actions:
\itemize{
\item Register and manage scalable targets - Register AWS or custom
resources as scalable targets (a resource that Application Auto
Scaling can scale), set minimum and maximum capacity limits, and
retrieve information on existing scalable targets.
\item Configure and manage automatic scaling - Define scaling policies to
dynamically scale your resources in response to CloudWatch alarms,
schedule one-time or recurring scaling actions, and retrieve your
recent scaling activity history.
\item Suspend and resume scaling - Temporarily suspend and later resume
automatic scaling by calling the
\href{https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html}{RegisterScalableTarget}
API action for any Application Auto Scaling scalable target. You can
suspend and resume (individually or in combination) scale-out
activities that are triggered by a scaling policy, scale-in
activities that are triggered by a scaling policy, and scheduled
scaling.
}

To learn more about Application Auto Scaling, including information
about granting IAM users required permissions for Application Auto
Scaling actions, see the \href{https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html}{Application Auto Scaling User Guide}.
}
\section{Service syntax}{
\preformatted{svc <- applicationautoscaling(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=applicationautoscaling_delete_scaling_policy]{delete_scaling_policy} \tab Deletes the specified scaling policy for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_delete_scheduled_action]{delete_scheduled_action} \tab Deletes the specified scheduled action for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_deregister_scalable_target]{deregister_scalable_target} \tab Deregisters an Application Auto Scaling scalable target when you have finished using it\cr
\link[=applicationautoscaling_describe_scalable_targets]{describe_scalable_targets} \tab Gets information about the scalable targets in the specified namespace\cr
\link[=applicationautoscaling_describe_scaling_activities]{describe_scaling_activities} \tab Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks\cr
\link[=applicationautoscaling_describe_scaling_policies]{describe_scaling_policies} \tab Describes the Application Auto Scaling scaling policies for the specified service namespace\cr
\link[=applicationautoscaling_describe_scheduled_actions]{describe_scheduled_actions} \tab Describes the Application Auto Scaling scheduled actions for the specified service namespace\cr
\link[=applicationautoscaling_put_scaling_policy]{put_scaling_policy} \tab Creates or updates a scaling policy for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_put_scheduled_action]{put_scheduled_action} \tab Creates or updates a scheduled action for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_register_scalable_target]{register_scalable_target} \tab Registers or updates a scalable target
}
}

\examples{
\dontrun{
svc <- applicationautoscaling()
# This example deletes a scaling policy for the Amazon ECS service called
# web-app, which is running in the default cluster.
svc$delete_scaling_policy(
  PolicyName = "web-app-cpu-lt-25",
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs"
)
}

}
