% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{acmpca}
\alias{acmpca}
\title{AWS Certificate Manager Private Certificate Authority}
\usage{
acmpca()
}
\description{
You can use the ACM PCA API to create a private certificate authority
(CA). You must first call the CreateCertificateAuthority operation. If
successful, the operation returns an Amazon Resource Name (ARN) for your
private CA. Use this ARN as input to the GetCertificateAuthorityCsr
operation to retrieve the certificate signing request (CSR) for your
private CA certificate. Sign the CSR using the root or an intermediate
CA in your on-premises PKI hierarchy, and call the
ImportCertificateAuthorityCertificate to import your signed private CA
certificate into ACM PCA.

Use your private CA to issue and revoke certificates. These are private
certificates that identify and secure client computers, servers,
applications, services, devices, and users over SSLS/TLS connections
within your organization. Call the IssueCertificate operation to issue a
certificate. Call the RevokeCertificate operation to revoke a
certificate.

Certificates issued by your private CA can be trusted only within your
organization, not publicly.

Your private CA can optionally create a certificate revocation list
(CRL) to track the certificates you revoke. To create a CRL, you must
specify a RevocationConfiguration object when you call the
CreateCertificateAuthority operation. ACM PCA writes the CRL to an S3
bucket that you specify. You must specify a bucket policy that grants
ACM PCA write permission.

You can also call the CreateCertificateAuthorityAuditReport to create an
optional audit report, which enumerates all of the issued, valid,
expired, and revoked certificates from the CA.

Each ACM PCA API operation has a throttling limit which determines the
number of times the operation can be called per second. For more
information, see \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaLimits.html#PcaLimits-api}{API Rate Limits in ACM PCA}
in the ACM PCA user guide.
}
\section{Operations}{

\tabular{ll}{
\link[=acmpca_create_certificate_authority]{create_certificate_authority} \tab Creates a private subordinate certificate authority (CA) \cr
\link[=acmpca_create_certificate_authority_audit_report]{create_certificate_authority_audit_report} \tab Creates an audit report that lists every time that your CA private key is used \cr
\link[=acmpca_create_permission]{create_permission} \tab Assigns permissions from a private CA to a designated AWS service \cr
\link[=acmpca_delete_certificate_authority]{delete_certificate_authority} \tab Deletes a private certificate authority (CA) \cr
\link[=acmpca_delete_permission]{delete_permission} \tab Revokes permissions that a private CA assigned to a designated AWS service \cr
\link[=acmpca_describe_certificate_authority]{describe_certificate_authority} \tab Lists information about your private certificate authority (CA) \cr
\link[=acmpca_describe_certificate_authority_audit_report]{describe_certificate_authority_audit_report} \tab Lists information about a specific audit report created by calling the CreateCertificateAuthorityAuditReport operation\cr
\link[=acmpca_get_certificate]{get_certificate} \tab Retrieves a certificate from your private CA \cr
\link[=acmpca_get_certificate_authority_certificate]{get_certificate_authority_certificate} \tab Retrieves the certificate and certificate chain for your private certificate authority (CA) \cr
\link[=acmpca_get_certificate_authority_csr]{get_certificate_authority_csr} \tab Retrieves the certificate signing request (CSR) for your private certificate authority (CA) \cr
\link[=acmpca_import_certificate_authority_certificate]{import_certificate_authority_certificate} \tab Imports your signed private CA certificate into ACM PCA \cr
\link[=acmpca_issue_certificate]{issue_certificate} \tab Uses your private certificate authority (CA) to issue a client certificate \cr
\link[=acmpca_list_certificate_authorities]{list_certificate_authorities} \tab Lists the private certificate authorities that you created by using the CreateCertificateAuthority operation \cr
\link[=acmpca_list_permissions]{list_permissions} \tab Lists all the permissions, if any, that have been assigned by a private CA \cr
\link[=acmpca_list_tags]{list_tags} \tab Lists the tags, if any, that are associated with your private CA \cr
\link[=acmpca_restore_certificate_authority]{restore_certificate_authority} \tab Restores a certificate authority (CA) that is in the DELETED state \cr
\link[=acmpca_revoke_certificate]{revoke_certificate} \tab Revokes a certificate that you issued by calling the IssueCertificate operation \cr
\link[=acmpca_tag_certificate_authority]{tag_certificate_authority} \tab Adds one or more tags to your private CA \cr
\link[=acmpca_untag_certificate_authority]{untag_certificate_authority} \tab Remove one or more tags from your private CA \cr
\link[=acmpca_update_certificate_authority]{update_certificate_authority} \tab Updates the status or configuration of a private certificate authority (CA)
}
}

\examples{
\donttest{svc <- acmpca()
svc$create_certificate_authority(
  Foo = 123
)}

}
