% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_analytics_configuration}
\alias{s3_put_bucket_analytics_configuration}
\title{Sets an analytics configuration for the bucket (specified by the
analytics configuration ID)}
\usage{
s3_put_bucket_analytics_configuration(
  Bucket,
  Id,
  AnalyticsConfiguration,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket to which an analytics configuration is stored.}

\item{Id}{[required] The ID that identifies the analytics configuration.}

\item{AnalyticsConfiguration}{[required] The configuration and any analyses for the analytics filter.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Sets an analytics configuration for the bucket (specified by the analytics configuration ID). You can have up to 1,000 analytics configurations per bucket.

See \url{https://paws-r.github.io/docs/s3/put_bucket_analytics_configuration.html} for full documentation.
}
\keyword{internal}
