% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_describe_access_points}
\alias{efs_describe_access_points}
\title{Returns the description of a specific Amazon EFS access point if the
AccessPointId is provided}
\usage{
efs_describe_access_points(MaxResults, NextToken, AccessPointId,
  FileSystemId)
}
\arguments{
\item{MaxResults}{(Optional) When retrieving all access points for a file system, you can
optionally specify the \code{MaxItems} parameter to limit the number of
objects returned in a response. The default value is 100.}

\item{NextToken}{\code{NextToken} is present if the response is paginated. You can use
\code{NextMarker} in the subsequent request to fetch the next page of access
point descriptions.}

\item{AccessPointId}{(Optional) Specifies an EFS access point to describe in the response;
mutually exclusive with \code{FileSystemId}.}

\item{FileSystemId}{(Optional) If you provide a \code{FileSystemId}, EFS returns all access
points for that file system; mutually exclusive with \code{AccessPointId}.}
}
\description{
Returns the description of a specific Amazon EFS access point if the
\code{AccessPointId} is provided. If you provide an EFS \code{FileSystemId}, it
returns descriptions of all access points for that file system. You can
provide either an \code{AccessPointId} or a \code{FileSystemId} in the request,
but not both.
}
\details{
This operation requires permissions for the
\code{elasticfilesystem:DescribeAccessPoints} action.
}
\section{Request syntax}{
\preformatted{svc$describe_access_points(
  MaxResults = 123,
  NextToken = "string",
  AccessPointId = "string",
  FileSystemId = "string"
)
}
}

\keyword{internal}
