% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_legal_hold}
\alias{s3_put_object_legal_hold}
\title{Applies a Legal Hold configuration to the specified object}
\usage{
s3_put_object_legal_hold(Bucket, Key, LegalHold, RequestPayer,
  VersionId, ContentMD5)
}
\arguments{
\item{Bucket}{[required] The bucket name containing the object that you want to place a Legal
Hold on.

When using this API with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this operation using an access point through the AWS SDKs,
you provide the access point ARN in place of the bucket name. For more
information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html}{Using Access Points}
in the \emph{Amazon Simple Storage Service Developer Guide}.}

\item{Key}{[required] The key name for the object that you want to place a Legal Hold on.}

\item{LegalHold}{Container element for the Legal Hold configuration you want to apply to
the specified object.}

\item{RequestPayer}{}

\item{VersionId}{The version ID of the object that you want to place a Legal Hold on.}

\item{ContentMD5}{The MD5 hash for the request body.}
}
\description{
Applies a Legal Hold configuration to the specified object.
}
\details{
\strong{Related Resources}
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html}{Locking Objects}
}
}
\section{Request syntax}{
\preformatted{svc$put_object_legal_hold(
  Bucket = "string",
  Key = "string",
  LegalHold = list(
    Status = "ON"|"OFF"
  ),
  RequestPayer = "requester",
  VersionId = "string",
  ContentMD5 = "string"
)
}
}

\keyword{internal}
