% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_set_vault_notifications}
\alias{glacier_set_vault_notifications}
\title{This operation configures notifications that will be sent when specific
events happen to a vault}
\usage{
glacier_set_vault_notifications(accountId, vaultName,
  vaultNotificationConfig)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
\'\code{-}\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
ID associated with the credentials used to sign the request. If you use
an account ID, do not include any hyphens (\'-\') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{vaultNotificationConfig}{Provides options for specifying notification configuration.}
}
\description{
This operation configures notifications that will be sent when specific
events happen to a vault. By default, you don\'t get any notifications.
}
\details{
To configure vault notifications, send a PUT request to the
\code{notification-configuration} subresource of the vault. The request
should include a JSON document that provides an Amazon SNS topic and
specific events for which you want Amazon S3 Glacier to send
notifications to the topic.

Amazon SNS topics must grant permission to the vault to be allowed to
publish notifications to the topic. You can configure a vault to publish
a notification for the following vault events:
\itemize{
\item \strong{ArchiveRetrievalCompleted} This event occurs when a job that was
initiated for an archive retrieval is completed (InitiateJob). The
status of the completed job can be \"Succeeded\" or \"Failed\". The
notification sent to the SNS topic is the same output as returned
from DescribeJob.
\item \strong{InventoryRetrievalCompleted} This event occurs when a job that
was initiated for an inventory retrieval is completed (InitiateJob).
The status of the completed job can be \"Succeeded\" or \"Failed\".
The notification sent to the SNS topic is the same output as
returned from DescribeJob.
}

An AWS account has full permission to perform all operations (actions).
However, AWS Identity and Access Management (IAM) users don\'t have any
permissions by default. You must grant them explicit permission to
perform specific actions. For more information, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html}{Access Control Using AWS Identity and Access Management (IAM)}.

For conceptual information and underlying REST API, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html}{Configuring Vault Notifications in Amazon S3 Glacier}
and \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html}{Set Vault Notification Configuration}
in the \emph{Amazon Glacier Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_vault_notifications(
  accountId = "string",
  vaultName = "string",
  vaultNotificationConfig = list(
    SNSTopic = "string",
    Events = list(
      "string"
    )
  )
)
}
}

\examples{
# The example sets the examplevault notification configuration.
\donttest{svc$set_vault_notifications(
  accountId = "-",
  vaultName = "examplevault",
  vaultNotificationConfig = list(
    Events = list(
      "ArchiveRetrievalCompleted",
      "InventoryRetrievalCompleted"
    ),
    SNSTopic = "arn:aws:sns:us-west-2:012345678901:mytopic"
  )
)}

}
\keyword{internal}
