% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_notification_configuration}
\alias{s3_put_bucket_notification_configuration}
\title{Enables notifications of specified events for a bucket}
\usage{
s3_put_bucket_notification_configuration(Bucket,
  NotificationConfiguration)
}
\arguments{
\item{Bucket}{[required]}

\item{NotificationConfiguration}{[required]}
}
\description{
Enables notifications of specified events for a bucket.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_notification_configuration(
  Bucket = "string",
  NotificationConfiguration = list(
    TopicConfigurations = list(
      list(
        Id = "string",
        TopicArn = "string",
        Events = list(
          "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
        ),
        Filter = list(
          Key = list(
            FilterRules = list(
              list(
                Name = "prefix"|"suffix",
                Value = "string"
              )
            )
          )
        )
      )
    ),
    QueueConfigurations = list(
      list(
        Id = "string",
        QueueArn = "string",
        Events = list(
          "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
        ),
        Filter = list(
          Key = list(
            FilterRules = list(
              list(
                Name = "prefix"|"suffix",
                Value = "string"
              )
            )
          )
        )
      )
    ),
    LambdaFunctionConfigurations = list(
      list(
        Id = "string",
        LambdaFunctionArn = "string",
        Events = list(
          "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
        ),
        Filter = list(
          Key = list(
            FilterRules = list(
              list(
                Name = "prefix"|"suffix",
                Value = "string"
              )
            )
          )
        )
      )
    )
  )
)
}
}

\examples{
# The following example sets notification configuration on a bucket to
# publish the object created events to an SNS topic.
\donttest{svc$put_bucket_notification_configuration(
  Bucket = "examplebucket",
  NotificationConfiguration = list(
    TopicConfigurations = list(
      list(
        Events = list(
          "s3:ObjectCreated:*"
        ),
        TopicArn = "arn:aws:sns:us-west-2:123456789012:s3-notification-topic"
      )
    )
  )
)}

}
\keyword{internal}
