% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_encryption}
\alias{s3_put_bucket_encryption}
\title{Creates a new server-side encryption configuration (or replaces an
existing one, if present)}
\usage{
s3_put_bucket_encryption(Bucket, ContentMD5,
  ServerSideEncryptionConfiguration)
}
\arguments{
\item{Bucket}{[required] Specifies default encryption for a bucket using server-side encryption
with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS).
For information about the Amazon S3 default encryption feature, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html}{Amazon S3 Default Bucket Encryption}
in the \emph{Amazon Simple Storage Service Developer Guide}.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the server-side encryption
configuration. This parameter is auto-populated when using the command
from the CLI.}

\item{ServerSideEncryptionConfiguration}{[required]}
}
\description{
Creates a new server-side encryption configuration (or replaces an
existing one, if present).
}
\section{Request syntax}{
\preformatted{svc$put_bucket_encryption(
  Bucket = "string",
  ContentMD5 = "string",
  ServerSideEncryptionConfiguration = list(
    Rules = list(
      list(
        ApplyServerSideEncryptionByDefault = list(
          SSEAlgorithm = "AES256"|"aws:kms",
          KMSMasterKeyID = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
