% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_tape_pools}
\alias{storagegateway_list_tape_pools}
\title{Lists custom tape pools}
\usage{
storagegateway_list_tape_pools(PoolARNs, Marker, Limit)
}
\arguments{
\item{PoolARNs}{The Amazon Resource Name (ARN) of each of the custom tape pools you want
to list. If you don't specify a custom tape pool ARN, the response lists
all custom tape pools.}

\item{Marker}{A string that indicates the position at which to begin the returned list
of tape pools.}

\item{Limit}{An optional number limit for the tape pools in the list returned by this
call.}
}
\description{
Lists custom tape pools. You specify custom tape pools to list by
specifying one or more custom tape pool Amazon Resource Names (ARNs). If
you don't specify a custom tape pool ARN, the operation lists all custom
tape pools.

This operation supports pagination. You can optionally specify the
\code{Limit} parameter in the body to limit the number of tape pools in the
response. If the number of tape pools returned in the response is
truncated, the response includes a \code{Marker} element that you can use in
your subsequent request to retrieve the next set of tape pools.
}
\section{Request syntax}{
\preformatted{svc$list_tape_pools(
  PoolARNs = list(
    "string"
  ),
  Marker = "string",
  Limit = 123
)
}
}

\keyword{internal}
