% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_cors}
\alias{s3_put_bucket_cors}
\title{Sets the cors configuration for your bucket}
\usage{
s3_put_bucket_cors(Bucket, CORSConfiguration, ContentMD5,
  ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] Specifies the bucket impacted by the \code{cors}configuration.}

\item{CORSConfiguration}{[required] Describes the cross-origin access configuration for objects in an Amazon
S3 bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html}{Enabling Cross-Origin Resource Sharing} in
the \emph{Amazon Simple Storage Service Developer Guide}.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the data. This header must be
used as a message integrity check to verify that the request body was
not corrupted in transit. For more information, go to \href{https://www.ietf.org/rfc/rfc1864.txt}{RFC 1864.}

For requests made using the AWS Command Line Interface (CLI) or AWS
SDKs, this field is calculated automatically.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Sets the \code{cors} configuration for your bucket. If the configuration
exists, Amazon S3 replaces it.

To use this operation, you must be allowed to perform the
\code{s3:PutBucketCORS} action. By default, the bucket owner has this
permission and can grant it to others.

You set this configuration on a bucket so that the bucket can service
cross-origin requests. For example, you might want to enable a request
whose origin is \verb{http://www.example.com} to access your Amazon S3 bucket
at \code{my.example.bucket.com} by using the browser's \code{XMLHttpRequest}
capability.

To enable cross-origin resource sharing (CORS) on a bucket, you add the
\code{cors} subresource to the bucket. The \code{cors} subresource is an XML
document in which you configure rules that identify origins and the HTTP
methods that can be executed on your bucket. The document is limited to
64 KB in size.

When Amazon S3 receives a cross-origin request (or a pre-flight OPTIONS
request) against a bucket, it evaluates the \code{cors} configuration on the
bucket and uses the first \code{CORSRule} rule that matches the incoming
browser request to enable a cross-origin request. For a rule to match,
the following conditions must be met:
\itemize{
\item The request's \code{Origin} header must match \code{AllowedOrigin} elements.
\item The request method (for example, GET, PUT, HEAD, and so on) or the
\code{Access-Control-Request-Method} header in case of a pre-flight
\code{OPTIONS} request must be one of the \code{AllowedMethod} elements.
\item Every header specified in the \code{Access-Control-Request-Headers}
request header of a pre-flight request must match an \code{AllowedHeader}
element.
}

For more information about CORS, go to \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html}{Enabling Cross-Origin Resource Sharing} in
the \emph{Amazon Simple Storage Service Developer Guide}.

\strong{Related Resources}
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html}{GetBucketCors}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html}{DeleteBucketCors}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html}{RESTOPTIONSobject}
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_cors(
  Bucket = "string",
  CORSConfiguration = list(
    CORSRules = list(
      list(
        AllowedHeaders = list(
          "string"
        ),
        AllowedMethods = list(
          "string"
        ),
        AllowedOrigins = list(
          "string"
        ),
        ExposeHeaders = list(
          "string"
        ),
        MaxAgeSeconds = 123
      )
    )
  ),
  ContentMD5 = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example enables PUT, POST, and DELETE requests from
# www.example.com, and enables GET requests from any domain.
svc$put_bucket_cors(
  Bucket = "",
  CORSConfiguration = list(
    CORSRules = list(
      list(
        AllowedHeaders = list(
          "*"
        ),
        AllowedMethods = list(
          "PUT",
          "POST",
          "DELETE"
        ),
        AllowedOrigins = list(
          "http://www.example.com"
        ),
        ExposeHeaders = list(
          "x-amz-server-side-encryption"
        ),
        MaxAgeSeconds = 3000L
      ),
      list(
        AllowedHeaders = list(
          "Authorization"
        ),
        AllowedMethods = list(
          "GET"
        ),
        AllowedOrigins = list(
          "*"
        ),
        MaxAgeSeconds = 3000L
      )
    )
  ),
  ContentMD5 = ""
)
}

}
\keyword{internal}
