% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_create_bucket}
\alias{s3_create_bucket}
\title{Creates a new bucket}
\usage{
s3_create_bucket(ACL, Bucket, CreateBucketConfiguration,
  GrantFullControl, GrantRead, GrantReadACP, GrantWrite, GrantWriteACP,
  ObjectLockEnabledForBucket)
}
\arguments{
\item{ACL}{The canned ACL to apply to the bucket.}

\item{Bucket}{[required]}

\item{CreateBucketConfiguration}{}

\item{GrantFullControl}{Allows grantee the read, write, read ACP, and write ACP permissions on
the bucket.}

\item{GrantRead}{Allows grantee to list the objects in the bucket.}

\item{GrantReadACP}{Allows grantee to read the bucket ACL.}

\item{GrantWrite}{Allows grantee to create, overwrite, and delete any object in the
bucket.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable bucket.}

\item{ObjectLockEnabledForBucket}{Specifies whether you want S3 Object Lock to be enabled for the new
bucket.}
}
\description{
Creates a new bucket.
}
\section{Request syntax}{
\preformatted{svc$create_bucket(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read",
  Bucket = "string",
  CreateBucketConfiguration = list(
    LocationConstraint = "EU"|"eu-west-1"|"us-west-1"|"us-west-2"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"|"cn-north-1"|"eu-central-1"
  ),
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWrite = "string",
  GrantWriteACP = "string",
  ObjectLockEnabledForBucket = TRUE|FALSE
)
}
}

\examples{
# The following example creates a bucket. The request specifies an AWS
# region where to create the bucket.
\donttest{svc$create_bucket(
  Bucket = "examplebucket",
  CreateBucketConfiguration = list(
    LocationConstraint = "eu-west-1"
  )
)}

# The following example creates a bucket.
\donttest{svc$create_bucket(
  Bucket = "examplebucket"
)}

}
\keyword{internal}
