% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlm_operations.R
\name{dlm_create_lifecycle_policy}
\alias{dlm_create_lifecycle_policy}
\title{Creates a policy to manage the lifecycle of the specified AWS resources}
\usage{
dlm_create_lifecycle_policy(ExecutionRoleArn, Description, State,
  PolicyDetails)
}
\arguments{
\item{ExecutionRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role used to run the
operations specified by the lifecycle policy.}

\item{Description}{[required] A description of the lifecycle policy. The characters \^[0-9A-Za-z
\_-]+\$ are supported.}

\item{State}{[required] The desired activation state of the lifecycle policy after creation.}

\item{PolicyDetails}{[required] The configuration details of the lifecycle policy.

Target tags cannot be re-used across lifecycle policies.}
}
\description{
Creates a policy to manage the lifecycle of the specified AWS resources.
You can create up to 100 lifecycle policies.
}
\section{Request syntax}{
\preformatted{svc$create_lifecycle_policy(
  ExecutionRoleArn = "string",
  Description = "string",
  State = "ENABLED"|"DISABLED",
  PolicyDetails = list(
    ResourceTypes = list(
      "VOLUME"
    ),
    TargetTags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    Schedules = list(
      list(
        Name = "string",
        CopyTags = TRUE|FALSE,
        TagsToAdd = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        CreateRule = list(
          Interval = 123,
          IntervalUnit = "HOURS",
          Times = list(
            "string"
          )
        ),
        RetainRule = list(
          Count = 123
        )
      )
    )
  )
)
}
}

\keyword{internal}
