# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sts_service.R
NULL

#' Returns a set of temporary security credentials that you can use to
#' access Amazon Web Services resources
#'
#' @description
#' Returns a set of temporary security credentials that you can use to access Amazon Web Services resources. These temporary credentials consist of an access key ID, a secret access key, and a security token. Typically, you use [`assume_role`][sts_assume_role] within your account or for cross-account access. For a comparison of [`assume_role`][sts_assume_role] with other API operations that produce temporary credentials, see [Requesting Temporary Security Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html) and [Comparing the Amazon Web Services STS API operations](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sts_assume_role/](https://www.paws-r-sdk.com/docs/sts_assume_role/) for full documentation.
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role to assume.
#' @param RoleSessionName &#91;required&#93; An identifier for the assumed role session.
#' 
#' Use the role session name to uniquely identify a session when the same
#' role is assumed by different principals or for different reasons. In
#' cross-account scenarios, the role session name is visible to, and can be
#' logged by the account that owns the role. The role session name is also
#' used in the ARN of the assumed role principal. This means that
#' subsequent cross-account API requests that use the temporary security
#' credentials will expose the role session name to the external account in
#' their CloudTrail logs.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@@-
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as managed session policies. The policies must exist in the
#' same account as the role.
#' 
#' This parameter is optional. You can provide up to 10 managed policy
#' ARNs. However, the plaintext that you use for both inline and managed
#' session policies can't exceed 2,048 characters. For more information
#' about ARNs, see [Amazon Resource Names (ARNs) and Amazon Web Services
#' Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the Amazon Web Services General Reference.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' 
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session's permissions are the intersection of the role's
#' identity-based policy and the session policies. You can use the role's
#' temporary credentials in subsequent Amazon Web Services API calls to
#' access resources in the account that owns the role. You cannot use
#' session policies to grant more permissions than those allowed by the
#' identity-based policy of the role that is being assumed. For more
#' information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' This parameter is optional. Passing policies to this operation returns
#' new temporary credentials. The resulting session's permissions are the
#' intersection of the role's identity-based policy and the session
#' policies. You can use the role's temporary credentials in subsequent
#' Amazon Web Services API calls to access resources in the account that
#' owns the role. You cannot use session policies to grant more permissions
#' than those allowed by the identity-based policy of the role that is
#' being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The plaintext that you use for both inline and managed session policies
#' can't exceed 2,048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (``U+0020`` through ``U+00FF``). It can also include the tab
#' (``U+0009``), linefeed (``U+000A``), and carriage return (``U+000D``) characters.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' @param DurationSeconds The duration, in seconds, of the role session. The value specified can
#' range from 900 seconds (15 minutes) up to the maximum session duration
#' set for the role. The maximum session duration setting can have a value
#' from 1 hour to 12 hours. If you specify a value higher than this setting
#' or the administrator setting (whichever is lower), the operation fails.
#' For example, if you specify a session duration of 12 hours, but your
#' administrator set the maximum session duration to 6 hours, your
#' operation fails.
#' 
#' Role chaining limits your Amazon Web Services CLI or Amazon Web Services
#' API role session to a maximum of one hour. When you use the
#' [`assume_role`][sts_assume_role] API operation to assume a role, you can
#' specify the duration of your role session with the `DurationSeconds`
#' parameter. You can specify a parameter value of up to 43200 seconds (12
#' hours), depending on the maximum session duration setting for your role.
#' However, if you assume a role using role chaining and provide a
#' `DurationSeconds` parameter value greater than one hour, the operation
#' fails. To learn how to view the maximum value for your role, see [View
#' the Maximum Session Duration Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage-assume.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*.
#' 
#' By default, the value is set to `3600` seconds.
#' 
#' The `DurationSeconds` parameter is separate from the duration of a
#' console session that you might request using the returned credentials.
#' The request to the federation endpoint for a console sign-in token takes
#' a `SessionDuration` parameter that specifies the maximum length of the
#' console session. For more information, see [Creating a URL that Enables
#' Federated Users to Access the Amazon Web Services Management
#' Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html)
#' in the *IAM User Guide*.
#' @param Tags A list of session tags that you want to pass. Each session tag consists
#' of a key name and an associated value. For more information about
#' session tags, see [Tagging Amazon Web Services STS
#' Sessions](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. You can pass up to 50 session tags. The
#' plaintext session tag keys can’t exceed 128 characters, and the values
#' can’t exceed 256 characters. For these and additional limits, see [IAM
#' and STS Character
#' Limits](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length)
#' in the *IAM User Guide*.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' 
#' You can pass a session tag with the same key as a tag that is already
#' attached to the role. When you do, session tags override a role tag with
#' the same key.
#' 
#' Tag key–value pairs are not case sensitive, but case is preserved. This
#' means that you cannot have separate `Department` and `department` tag
#' keys. Assume that the role has the `Department`=`Marketing` tag and you
#' pass the `department`=`engineering` session tag. `Department` and
#' `department` are not saved as separate tags, and the session tag passed
#' in the request takes precedence over the role tag.
#' 
#' Additionally, if you used temporary credentials to perform this
#' operation, the new session inherits any transitive session tags from the
#' calling session. If you pass a session tag with the same key as an
#' inherited tag, the operation fails. To view the inherited tags for a
#' session, see the CloudTrail logs. For more information, see [Viewing
#' Session Tags in
#' CloudTrail](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html#id_session-tags_ctlogs)
#' in the *IAM User Guide*.
#' @param TransitiveTagKeys A list of keys for session tags that you want to set as transitive. If
#' you set a tag key as transitive, the corresponding key and value passes
#' to subsequent sessions in a role chain. For more information, see
#' [Chaining Roles with Session
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html#id_session-tags_role-chaining)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. When you set session tags as transitive, the
#' session policy and session tags packed binary limit is not affected.
#' 
#' If you choose not to specify a transitive tag key, then no tags are
#' passed from this session to any subsequent sessions.
#' @param ExternalId A unique identifier that might be required when you assume a role in
#' another account. If the administrator of the account to which the role
#' belongs provided you with an external ID, then provide that value in the
#' `ExternalId` parameter. This value can be any string, such as a
#' passphrase or account number. A cross-account role is usually set up to
#' trust everyone in an account. Therefore, the administrator of the
#' trusting account might send an external ID to the administrator of the
#' trusted account. That way, only someone with the ID can assume the role,
#' rather than everyone in the account. For more information about the
#' external ID, see [How to Use an External ID When Granting Access to Your
#' Amazon Web Services Resources to a Third
#' Party](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_common-scenarios_third-party.html)
#' in the *IAM User Guide*.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@@:/-
#' @param SerialNumber The identification number of the MFA device that is associated with the
#' user who is making the [`assume_role`][sts_assume_role] call. Specify
#' this value if the trust policy of the role being assumed includes a
#' condition that requires MFA authentication. The value is either the
#' serial number for a hardware device (such as `GAHT12345678`) or an
#' Amazon Resource Name (ARN) for a virtual device (such as
#' `arn:aws:iam::123456789012:mfa/user`).
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@@-
#' @param TokenCode The value provided by the MFA device, if the trust policy of the role
#' being assumed requires MFA. (In other words, if the policy includes a
#' condition that tests for MFA). If the role being assumed requires MFA
#' and if the `TokenCode` value is missing or expired, the
#' [`assume_role`][sts_assume_role] call returns an "access denied" error.
#' 
#' The format for this parameter, as described by its regex pattern, is a
#' sequence of six numeric digits.
#' @param SourceIdentity The source identity specified by the principal that is calling the
#' [`assume_role`][sts_assume_role] operation.
#' 
#' You can require users to specify a source identity when they assume a
#' role. You do this by using the `sts:SourceIdentity` condition key in a
#' role trust policy. You can use source identity information in CloudTrail
#' logs to determine who took actions with a role. You can use the
#' `aws:SourceIdentity` condition key to further control access to Amazon
#' Web Services resources based on the value of source identity. For more
#' information about using source identity, see [Monitor and control
#' actions taken with assumed
#' roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html)
#' in the *IAM User Guide*.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@@-. You cannot use a value that begins with the text
#' `aws:`. This prefix is reserved for Amazon Web Services internal use.
#' @param ProvidedContexts A list of previously acquired trusted context assertions in the format
#' of a JSON array. The trusted context assertion is signed and encrypted
#' by Amazon Web Services STS.
#' 
#' The following is an example of a `ProvidedContext` value that includes a
#' single trusted context assertion and the ARN of the context provider
#' from which the trusted context assertion was generated.
#' 
#' `[{"ProviderArn":"arn:aws:iam::aws:contextProvider/IdentityCenter","ContextAssertion":"trusted-context-assertion"}]`
#'
#' @keywords internal
#'
#' @rdname sts_assume_role
sts_assume_role <- function(RoleArn, RoleSessionName, PolicyArns = NULL, Policy = NULL, DurationSeconds = NULL, Tags = NULL, TransitiveTagKeys = NULL, ExternalId = NULL, SerialNumber = NULL, TokenCode = NULL, SourceIdentity = NULL, ProvidedContexts = NULL) {
  op <- new_operation(
    name = "AssumeRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$assume_role_input(RoleArn = RoleArn, RoleSessionName = RoleSessionName, PolicyArns = PolicyArns, Policy = Policy, DurationSeconds = DurationSeconds, Tags = Tags, TransitiveTagKeys = TransitiveTagKeys, ExternalId = ExternalId, SerialNumber = SerialNumber, TokenCode = TokenCode, SourceIdentity = SourceIdentity, ProvidedContexts = ProvidedContexts)
  output <- .sts$assume_role_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$assume_role <- sts_assume_role

#' Returns a set of temporary security credentials for users who have been
#' authenticated via a SAML authentication response
#'
#' @description
#' Returns a set of temporary security credentials for users who have been authenticated via a SAML authentication response. This operation provides a mechanism for tying an enterprise identity store or directory to role-based Amazon Web Services access without user-specific credentials or configuration. For a comparison of [`assume_role_with_saml`][sts_assume_role_with_saml] with the other API operations that produce temporary credentials, see [Requesting Temporary Security Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html) and [Comparing the Amazon Web Services STS API operations](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sts_assume_role_with_saml/](https://www.paws-r-sdk.com/docs/sts_assume_role_with_saml/) for full documentation.
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role that the caller is assuming.
#' @param PrincipalArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider in IAM that
#' describes the IdP.
#' @param SAMLAssertion &#91;required&#93; The base64 encoded SAML authentication response provided by the IdP.
#' 
#' For more information, see [Configuring a Relying Party and Adding
#' Claims](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml_relying-party.html)
#' in the *IAM User Guide*.
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as managed session policies. The policies must exist in the
#' same account as the role.
#' 
#' This parameter is optional. You can provide up to 10 managed policy
#' ARNs. However, the plaintext that you use for both inline and managed
#' session policies can't exceed 2,048 characters. For more information
#' about ARNs, see [Amazon Resource Names (ARNs) and Amazon Web Services
#' Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the Amazon Web Services General Reference.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' 
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session's permissions are the intersection of the role's
#' identity-based policy and the session policies. You can use the role's
#' temporary credentials in subsequent Amazon Web Services API calls to
#' access resources in the account that owns the role. You cannot use
#' session policies to grant more permissions than those allowed by the
#' identity-based policy of the role that is being assumed. For more
#' information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' This parameter is optional. Passing policies to this operation returns
#' new temporary credentials. The resulting session's permissions are the
#' intersection of the role's identity-based policy and the session
#' policies. You can use the role's temporary credentials in subsequent
#' Amazon Web Services API calls to access resources in the account that
#' owns the role. You cannot use session policies to grant more permissions
#' than those allowed by the identity-based policy of the role that is
#' being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The plaintext that you use for both inline and managed session policies
#' can't exceed 2,048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (``U+0020`` through ``U+00FF``). It can also include the tab
#' (``U+0009``), linefeed (``U+000A``), and carriage return (``U+000D``) characters.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' @param DurationSeconds The duration, in seconds, of the role session. Your role session lasts
#' for the duration that you specify for the `DurationSeconds` parameter,
#' or until the time specified in the SAML authentication response's
#' `SessionNotOnOrAfter` value, whichever is shorter. You can provide a
#' `DurationSeconds` value from 900 seconds (15 minutes) up to the maximum
#' session duration setting for the role. This setting can have a value
#' from 1 hour to 12 hours. If you specify a value higher than this
#' setting, the operation fails. For example, if you specify a session
#' duration of 12 hours, but your administrator set the maximum session
#' duration to 6 hours, your operation fails. To learn how to view the
#' maximum value for your role, see [View the Maximum Session Duration
#' Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage-assume.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*.
#' 
#' By default, the value is set to `3600` seconds.
#' 
#' The `DurationSeconds` parameter is separate from the duration of a
#' console session that you might request using the returned credentials.
#' The request to the federation endpoint for a console sign-in token takes
#' a `SessionDuration` parameter that specifies the maximum length of the
#' console session. For more information, see [Creating a URL that Enables
#' Federated Users to Access the Amazon Web Services Management
#' Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname sts_assume_role_with_saml
sts_assume_role_with_saml <- function(RoleArn, PrincipalArn, SAMLAssertion, PolicyArns = NULL, Policy = NULL, DurationSeconds = NULL) {
  op <- new_operation(
    name = "AssumeRoleWithSAML",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$assume_role_with_saml_input(RoleArn = RoleArn, PrincipalArn = PrincipalArn, SAMLAssertion = SAMLAssertion, PolicyArns = PolicyArns, Policy = Policy, DurationSeconds = DurationSeconds)
  output <- .sts$assume_role_with_saml_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$assume_role_with_saml <- sts_assume_role_with_saml

#' Returns a set of temporary security credentials for users who have been
#' authenticated in a mobile or web application with a web identity
#' provider
#'
#' @description
#' Returns a set of temporary security credentials for users who have been authenticated in a mobile or web application with a web identity provider. Example providers include the OAuth 2.0 providers Login with Amazon and Facebook, or any OpenID Connect-compatible identity provider such as Google or [Amazon Cognito federated identities](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sts_assume_role_with_web_identity/](https://www.paws-r-sdk.com/docs/sts_assume_role_with_web_identity/) for full documentation.
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role that the caller is assuming.
#' @param RoleSessionName &#91;required&#93; An identifier for the assumed role session. Typically, you pass the name
#' or identifier that is associated with the user who is using your
#' application. That way, the temporary security credentials that your
#' application will use are associated with that user. This session name is
#' included as part of the ARN and assumed role ID in the `AssumedRoleUser`
#' response element.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@@-
#' @param WebIdentityToken &#91;required&#93; The OAuth 2.0 access token or OpenID Connect ID token that is provided
#' by the identity provider. Your application must get this token by
#' authenticating the user who is using your application with a web
#' identity provider before the application makes an
#' [`assume_role_with_web_identity`][sts_assume_role_with_web_identity]
#' call. Only tokens with RSA algorithms (RS256) are supported.
#' @param ProviderId The fully qualified host component of the domain name of the OAuth 2.0
#' identity provider. Do not specify this value for an OpenID Connect
#' identity provider.
#' 
#' Currently `www.amazon.com` and `graph.facebook.com` are the only
#' supported identity providers for OAuth 2.0 access tokens. Do not include
#' URL schemes and port numbers.
#' 
#' Do not specify this value for OpenID Connect ID tokens.
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as managed session policies. The policies must exist in the
#' same account as the role.
#' 
#' This parameter is optional. You can provide up to 10 managed policy
#' ARNs. However, the plaintext that you use for both inline and managed
#' session policies can't exceed 2,048 characters. For more information
#' about ARNs, see [Amazon Resource Names (ARNs) and Amazon Web Services
#' Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the Amazon Web Services General Reference.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' 
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session's permissions are the intersection of the role's
#' identity-based policy and the session policies. You can use the role's
#' temporary credentials in subsequent Amazon Web Services API calls to
#' access resources in the account that owns the role. You cannot use
#' session policies to grant more permissions than those allowed by the
#' identity-based policy of the role that is being assumed. For more
#' information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' This parameter is optional. Passing policies to this operation returns
#' new temporary credentials. The resulting session's permissions are the
#' intersection of the role's identity-based policy and the session
#' policies. You can use the role's temporary credentials in subsequent
#' Amazon Web Services API calls to access resources in the account that
#' owns the role. You cannot use session policies to grant more permissions
#' than those allowed by the identity-based policy of the role that is
#' being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The plaintext that you use for both inline and managed session policies
#' can't exceed 2,048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (``U+0020`` through ``U+00FF``). It can also include the tab
#' (``U+0009``), linefeed (``U+000A``), and carriage return (``U+000D``) characters.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' @param DurationSeconds The duration, in seconds, of the role session. The value can range from
#' 900 seconds (15 minutes) up to the maximum session duration setting for
#' the role. This setting can have a value from 1 hour to 12 hours. If you
#' specify a value higher than this setting, the operation fails. For
#' example, if you specify a session duration of 12 hours, but your
#' administrator set the maximum session duration to 6 hours, your
#' operation fails. To learn how to view the maximum value for your role,
#' see [View the Maximum Session Duration Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage-assume.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*.
#' 
#' By default, the value is set to `3600` seconds.
#' 
#' The `DurationSeconds` parameter is separate from the duration of a
#' console session that you might request using the returned credentials.
#' The request to the federation endpoint for a console sign-in token takes
#' a `SessionDuration` parameter that specifies the maximum length of the
#' console session. For more information, see [Creating a URL that Enables
#' Federated Users to Access the Amazon Web Services Management
#' Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname sts_assume_role_with_web_identity
sts_assume_role_with_web_identity <- function(RoleArn, RoleSessionName, WebIdentityToken, ProviderId = NULL, PolicyArns = NULL, Policy = NULL, DurationSeconds = NULL) {
  op <- new_operation(
    name = "AssumeRoleWithWebIdentity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$assume_role_with_web_identity_input(RoleArn = RoleArn, RoleSessionName = RoleSessionName, WebIdentityToken = WebIdentityToken, ProviderId = ProviderId, PolicyArns = PolicyArns, Policy = Policy, DurationSeconds = DurationSeconds)
  output <- .sts$assume_role_with_web_identity_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$assume_role_with_web_identity <- sts_assume_role_with_web_identity

#' Decodes additional information about the authorization status of a
#' request from an encoded message returned in response to an Amazon Web
#' Services request
#'
#' @description
#' Decodes additional information about the authorization status of a request from an encoded message returned in response to an Amazon Web Services request.
#'
#' See [https://www.paws-r-sdk.com/docs/sts_decode_authorization_message/](https://www.paws-r-sdk.com/docs/sts_decode_authorization_message/) for full documentation.
#'
#' @param EncodedMessage &#91;required&#93; The encoded message that was returned with the response.
#'
#' @keywords internal
#'
#' @rdname sts_decode_authorization_message
sts_decode_authorization_message <- function(EncodedMessage) {
  op <- new_operation(
    name = "DecodeAuthorizationMessage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$decode_authorization_message_input(EncodedMessage = EncodedMessage)
  output <- .sts$decode_authorization_message_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$decode_authorization_message <- sts_decode_authorization_message

#' Returns the account identifier for the specified access key ID
#'
#' @description
#' Returns the account identifier for the specified access key ID.
#'
#' See [https://www.paws-r-sdk.com/docs/sts_get_access_key_info/](https://www.paws-r-sdk.com/docs/sts_get_access_key_info/) for full documentation.
#'
#' @param AccessKeyId &#91;required&#93; The identifier of an access key.
#' 
#' This parameter allows (through its regex pattern) a string of characters
#' that can consist of any upper- or lowercase letter or digit.
#'
#' @keywords internal
#'
#' @rdname sts_get_access_key_info
sts_get_access_key_info <- function(AccessKeyId) {
  op <- new_operation(
    name = "GetAccessKeyInfo",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$get_access_key_info_input(AccessKeyId = AccessKeyId)
  output <- .sts$get_access_key_info_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$get_access_key_info <- sts_get_access_key_info

#' Returns details about the IAM user or role whose credentials are used to
#' call the operation
#'
#' @description
#' Returns details about the IAM user or role whose credentials are used to call the operation.
#'
#' See [https://www.paws-r-sdk.com/docs/sts_get_caller_identity/](https://www.paws-r-sdk.com/docs/sts_get_caller_identity/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname sts_get_caller_identity
sts_get_caller_identity <- function() {
  op <- new_operation(
    name = "GetCallerIdentity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$get_caller_identity_input()
  output <- .sts$get_caller_identity_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$get_caller_identity <- sts_get_caller_identity

#' Returns a set of temporary security credentials (consisting of an access
#' key ID, a secret access key, and a security token) for a user
#'
#' @description
#' Returns a set of temporary security credentials (consisting of an access key ID, a secret access key, and a security token) for a user. A typical use is in a proxy application that gets temporary security credentials on behalf of distributed applications inside a corporate network.
#'
#' See [https://www.paws-r-sdk.com/docs/sts_get_federation_token/](https://www.paws-r-sdk.com/docs/sts_get_federation_token/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the federated user. The name is used as an identifier for
#' the temporary security credentials (such as `Bob`). For example, you can
#' reference the federated user name in a resource-based policy, such as in
#' an Amazon S3 bucket policy.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@@-
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' You must pass an inline or managed [session
#' policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policy
#' Amazon Resource Names (ARNs) to use as managed session policies.
#' 
#' This parameter is optional. However, if you do not pass any session
#' policies, then the resulting federated user session has no permissions.
#' 
#' When you pass session policies, the session permissions are the
#' intersection of the IAM user policies and the session policies that you
#' pass. This gives you a way to further restrict the permissions for a
#' federated user. You cannot use session policies to grant more
#' permissions than those that are defined in the permissions policy of the
#' IAM user. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The resulting credentials can be used to access a resource that has a
#' resource-based policy. If that policy specifically references the
#' federated user session in the `Principal` element of the policy, the
#' session has the permissions allowed by the policy. These permissions are
#' granted in addition to the permissions that are granted by the session
#' policies.
#' 
#' The plaintext that you use for both inline and managed session policies
#' can't exceed 2,048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (``U+0020`` through ``U+00FF``). It can also include the tab
#' (``U+0009``), linefeed (``U+000A``), and carriage return (``U+000D``) characters.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as a managed session policy. The policies must exist in the
#' same account as the IAM user that is requesting federated access.
#' 
#' You must pass an inline or managed [session
#' policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policy
#' Amazon Resource Names (ARNs) to use as managed session policies. The
#' plaintext that you use for both inline and managed session policies
#' can't exceed 2,048 characters. You can provide up to 10 managed policy
#' ARNs. For more information about ARNs, see [Amazon Resource Names (ARNs)
#' and Amazon Web Services Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the Amazon Web Services General Reference.
#' 
#' This parameter is optional. However, if you do not pass any session
#' policies, then the resulting federated user session has no permissions.
#' 
#' When you pass session policies, the session permissions are the
#' intersection of the IAM user policies and the session policies that you
#' pass. This gives you a way to further restrict the permissions for a
#' federated user. You cannot use session policies to grant more
#' permissions than those that are defined in the permissions policy of the
#' IAM user. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The resulting credentials can be used to access a resource that has a
#' resource-based policy. If that policy specifically references the
#' federated user session in the `Principal` element of the policy, the
#' session has the permissions allowed by the policy. These permissions are
#' granted in addition to the permissions that are granted by the session
#' policies.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' @param DurationSeconds The duration, in seconds, that the session should last. Acceptable
#' durations for federation sessions range from 900 seconds (15 minutes) to
#' 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the
#' default. Sessions obtained using root user credentials are restricted to
#' a maximum of 3,600 seconds (one hour). If the specified duration is
#' longer than one hour, the session obtained by using root user
#' credentials defaults to one hour.
#' @param Tags A list of session tags. Each session tag consists of a key name and an
#' associated value. For more information about session tags, see [Passing
#' Session Tags in
#' STS](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. You can pass up to 50 session tags. The
#' plaintext session tag keys can’t exceed 128 characters and the values
#' can’t exceed 256 characters. For these and additional limits, see [IAM
#' and STS Character
#' Limits](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length)
#' in the *IAM User Guide*.
#' 
#' An Amazon Web Services conversion compresses the passed inline session
#' policy, managed policy ARNs, and session tags into a packed binary
#' format that has a separate limit. Your request can fail for this limit
#' even if your plaintext meets the other requirements. The
#' `PackedPolicySize` response element indicates by percentage how close
#' the policies and tags for your request are to the upper size limit.
#' 
#' You can pass a session tag with the same key as a tag that is already
#' attached to the user you are federating. When you do, session tags
#' override a user tag with the same key.
#' 
#' Tag key–value pairs are not case sensitive, but case is preserved. This
#' means that you cannot have separate `Department` and `department` tag
#' keys. Assume that the role has the `Department`=`Marketing` tag and you
#' pass the `department`=`engineering` session tag. `Department` and
#' `department` are not saved as separate tags, and the session tag passed
#' in the request takes precedence over the role tag.
#'
#' @keywords internal
#'
#' @rdname sts_get_federation_token
sts_get_federation_token <- function(Name, Policy = NULL, PolicyArns = NULL, DurationSeconds = NULL, Tags = NULL) {
  op <- new_operation(
    name = "GetFederationToken",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$get_federation_token_input(Name = Name, Policy = Policy, PolicyArns = PolicyArns, DurationSeconds = DurationSeconds, Tags = Tags)
  output <- .sts$get_federation_token_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$get_federation_token <- sts_get_federation_token

#' Returns a set of temporary credentials for an Amazon Web Services
#' account or IAM user
#'
#' @description
#' Returns a set of temporary credentials for an Amazon Web Services account or IAM user. The credentials consist of an access key ID, a secret access key, and a security token. Typically, you use [`get_session_token`][sts_get_session_token] if you want to use MFA to protect programmatic calls to specific Amazon Web Services API operations like Amazon EC2 `StopInstances`.
#'
#' See [https://www.paws-r-sdk.com/docs/sts_get_session_token/](https://www.paws-r-sdk.com/docs/sts_get_session_token/) for full documentation.
#'
#' @param DurationSeconds The duration, in seconds, that the credentials should remain valid.
#' Acceptable durations for IAM user sessions range from 900 seconds (15
#' minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours)
#' as the default. Sessions for Amazon Web Services account owners are
#' restricted to a maximum of 3,600 seconds (one hour). If the duration is
#' longer than one hour, the session for Amazon Web Services account owners
#' defaults to one hour.
#' @param SerialNumber The identification number of the MFA device that is associated with the
#' IAM user who is making the [`get_session_token`][sts_get_session_token]
#' call. Specify this value if the IAM user has a policy that requires MFA
#' authentication. The value is either the serial number for a hardware
#' device (such as `GAHT12345678`) or an Amazon Resource Name (ARN) for a
#' virtual device (such as `arn:aws:iam::123456789012:mfa/user`). You can
#' find the device for an IAM user by going to the Amazon Web Services
#' Management Console and viewing the user's security credentials.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@@:/-
#' @param TokenCode The value provided by the MFA device, if MFA is required. If any policy
#' requires the IAM user to submit an MFA code, specify this value. If MFA
#' authentication is required, the user must provide a code when requesting
#' a set of temporary security credentials. A user who fails to provide the
#' code receives an "access denied" response when requesting resources that
#' require MFA authentication.
#' 
#' The format for this parameter, as described by its regex pattern, is a
#' sequence of six numeric digits.
#'
#' @keywords internal
#'
#' @rdname sts_get_session_token
sts_get_session_token <- function(DurationSeconds = NULL, SerialNumber = NULL, TokenCode = NULL) {
  op <- new_operation(
    name = "GetSessionToken",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .sts$get_session_token_input(DurationSeconds = DurationSeconds, SerialNumber = SerialNumber, TokenCode = TokenCode)
  output <- .sts$get_session_token_output()
  config <- get_config()
  svc <- .sts$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$get_session_token <- sts_get_session_token
