% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securitylake_operations.R
\name{securitylake_create_custom_log_source}
\alias{securitylake_create_custom_log_source}
\title{Adds a third-party custom source in Amazon Security Lake, from the
Amazon Web Services Region where you want to create a custom source}
\usage{
securitylake_create_custom_log_source(
  configuration = NULL,
  eventClasses = NULL,
  sourceName,
  sourceVersion = NULL
)
}
\arguments{
\item{configuration}{The configuration for the third-party custom source.}

\item{eventClasses}{The Open Cybersecurity Schema Framework (OCSF) event classes which
describes the type of data that the custom source will send to Security
Lake. The supported event classes are:
\itemize{
\item \code{ACCESS_ACTIVITY}
\item \code{FILE_ACTIVITY}
\item \code{KERNEL_ACTIVITY}
\item \code{KERNEL_EXTENSION}
\item \code{MEMORY_ACTIVITY}
\item \code{MODULE_ACTIVITY}
\item \code{PROCESS_ACTIVITY}
\item \code{REGISTRY_KEY_ACTIVITY}
\item \code{REGISTRY_VALUE_ACTIVITY}
\item \code{RESOURCE_ACTIVITY}
\item \code{SCHEDULED_JOB_ACTIVITY}
\item \code{SECURITY_FINDING}
\item \code{ACCOUNT_CHANGE}
\item \code{AUTHENTICATION}
\item \code{AUTHORIZATION}
\item \code{ENTITY_MANAGEMENT_AUDIT}
\item \code{DHCP_ACTIVITY}
\item \code{NETWORK_ACTIVITY}
\item \code{DNS_ACTIVITY}
\item \code{FTP_ACTIVITY}
\item \code{HTTP_ACTIVITY}
\item \code{RDP_ACTIVITY}
\item \code{SMB_ACTIVITY}
\item \code{SSH_ACTIVITY}
\item \code{CONFIG_STATE}
\item \code{INVENTORY_INFO}
\item \code{EMAIL_ACTIVITY}
\item \code{API_ACTIVITY}
\item \code{CLOUD_API}
}}

\item{sourceName}{[required] Specify the name for a third-party custom source. This must be a
Regionally unique value.}

\item{sourceVersion}{Specify the source version for the third-party custom source, to limit
log collection to a specific version of custom data source.}
}
\description{
Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from the custom source. In addition, this operation also creates an associated Glue table and an Glue crawler.

See \url{https://www.paws-r-sdk.com/docs/securitylake_create_custom_log_source/} for full documentation.
}
\keyword{internal}
