% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_list_resources_for_web_acl}
\alias{wafv2_list_resources_for_web_acl}
\title{Retrieves an array of the Amazon Resource Names (ARNs) for the regional
resources that are associated with the specified web ACL}
\usage{
wafv2_list_resources_for_web_acl(WebACLArn, ResourceType = NULL)
}
\arguments{
\item{WebACLArn}{[required] The Amazon Resource Name (ARN) of the web ACL.}

\item{ResourceType}{Used for web ACLs that are scoped for regional applications. A regional
application can be an Application Load Balancer (ALB), an Amazon API
Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool,
an App Runner service, or an Amazon Web Services Verified Access
instance.

If you don't provide a resource type, the call uses the resource type
\code{APPLICATION_LOAD_BALANCER}.

Default: \code{APPLICATION_LOAD_BALANCER}}
}
\description{
Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call \code{ListDistributionsByWebACLId}.

See \url{https://www.paws-r-sdk.com/docs/wafv2_list_resources_for_web_acl/} for full documentation.
}
\keyword{internal}
