% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_get_regex_pattern_set}
\alias{wafv2_get_regex_pattern_set}
\title{Retrieves the specified RegexPatternSet}
\usage{
wafv2_get_regex_pattern_set(Name, Scope, Id)
}
\arguments{
\item{Name}{[required] The name of the set. You cannot change the name after you create the
set.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
or an Amazon Cognito user pool.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{Id}{[required] A unique identifier for the set. This ID is returned in the responses to
create and list commands. You provide it to operations like update and
delete.}
}
\description{
Retrieves the specified RegexPatternSet.

See \url{https://paws-r.github.io/docs/wafv2/get_regex_pattern_set.html} for full documentation.
}
\keyword{internal}
