% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_create_custom_data_identifier}
\alias{macie2_create_custom_data_identifier}
\title{Creates and defines the criteria and other settings for a custom data
identifier}
\usage{
macie2_create_custom_data_identifier(
  clientToken = NULL,
  description = NULL,
  ignoreWords = NULL,
  keywords = NULL,
  maximumMatchDistance = NULL,
  name,
  regex,
  severityLevels = NULL,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive token that you provide to ensure the
idempotency of the request.}

\item{description}{A custom description of the custom data identifier. The description can
contain as many as 512 characters.

We strongly recommend that you avoid including any sensitive data in the
description of a custom data identifier. Other users of your account
might be able to see this description, depending on the actions that
they're allowed to perform in Amazon Macie.}

\item{ignoreWords}{An array that lists specific character sequences (\emph{ignore words}) to
exclude from the results. If the text matched by the regular expression
contains any string in this array, Amazon Macie ignores it. The array
can contain as many as 10 ignore words. Each ignore word can contain
4-90 UTF-8 characters. Ignore words are case sensitive.}

\item{keywords}{An array that lists specific character sequences (\emph{keywords}), one of
which must precede and be within proximity (maximumMatchDistance) of the
regular expression to match. The array can contain as many as 50
keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords
aren't case sensitive.}

\item{maximumMatchDistance}{The maximum number of characters that can exist between the end of at
least one complete character sequence specified by the keywords array
and the end of the text that matches the regex pattern. If a complete
keyword precedes all the text that matches the pattern and the keyword
is within the specified distance, Amazon Macie includes the result. The
distance can be 1-300 characters. The default value is 50.}

\item{name}{[required] A custom name for the custom data identifier. The name can contain as
many as 128 characters.

We strongly recommend that you avoid including any sensitive data in the
name of a custom data identifier. Other users of your account might be
able to see this name, depending on the actions that they're allowed to
perform in Amazon Macie.}

\item{regex}{[required] The regular expression (\emph{regex}) that defines the pattern to match. The
expression can contain as many as 512 characters.}

\item{severityLevels}{The severity to assign to findings that the custom data identifier
produces, based on the number of occurrences of text that matches the
custom data identifier's detection criteria. You can specify as many as
three SeverityLevel objects in this array, one for each severity: LOW,
MEDIUM, or HIGH. If you specify more than one, the occurrences
thresholds must be in ascending order by severity, moving from LOW to
HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3
object contains fewer occurrences than the lowest specified threshold,
Amazon Macie doesn't create a finding.

If you don't specify any values for this array, Macie creates findings
for S3 objects that contain at least one occurrence of text that matches
the detection criteria, and Macie assigns the MEDIUM severity to those
findings.}

\item{tags}{A map of key-value pairs that specifies the tags to associate with the
custom data identifier.

A custom data identifier can have a maximum of 50 tags. Each tag
consists of a tag key and an associated tag value. The maximum length of
a tag key is 128 characters. The maximum length of a tag value is 256
characters.}
}
\description{
Creates and defines the criteria and other settings for a custom data identifier.

See \url{https://paws-r.github.io/docs/macie2/create_custom_data_identifier.html} for full documentation.
}
\keyword{internal}
