% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_service_last_accessed_details}
\alias{iam_get_service_last_accessed_details}
\title{Retrieves a service last accessed report that was created using the
GenerateServiceLastAccessedDetails operation}
\usage{
iam_get_service_last_accessed_details(JobId, MaxItems = NULL, Marker = NULL)
}
\arguments{
\item{JobId}{[required] The ID of the request generated by the
\code{\link[=iam_generate_service_last_accessed_details]{generate_service_last_accessed_details}}
operation. The \code{JobId} returned by \code{GenerateServiceLastAccessedDetail}
must be used by the same role within a session, or by the same user when
used to call \code{GetServiceLastAccessedDetail}.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}
}
\description{
Retrieves a service last accessed report that was created using the \code{\link[=iam_generate_service_last_accessed_details]{generate_service_last_accessed_details}} operation. You can use the \code{JobId} parameter in \code{\link[=iam_get_service_last_accessed_details]{get_service_last_accessed_details}} to retrieve the status of your report job. When the report is complete, you can retrieve the generated report. The report includes a list of Amazon Web Services services that the resource (user, group, role, or managed policy) can access.

See \url{https://paws-r.github.io/docs/iam/get_service_last_accessed_details.html} for full documentation.
}
\keyword{internal}
