% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_virtual_mfa_device}
\alias{iam_create_virtual_mfa_device}
\title{Creates a new virtual MFA device for the Amazon Web Services account}
\usage{
iam_create_virtual_mfa_device(Path = NULL, VirtualMFADeviceName, Tags = NULL)
}
\arguments{
\item{Path}{The path for the virtual MFA device. For more information about paths,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{VirtualMFADeviceName}{[required] The name of the virtual MFA device. Use with path to uniquely identify a
virtual MFA device.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Tags}{A list of tags that you want to attach to the new IAM virtual MFA
device. Each tag consists of a key name and an associated value. For
more information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources}
in the \emph{IAM User Guide}.

If any one of the tags is invalid or if you exceed the allowed maximum
number of tags, then the entire request fails and the resource is not
created.}
}
\description{
Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual MFA, use \code{\link[=iam_enable_mfa_device]{enable_mfa_device}} to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_enable_virtual.html}{Using a virtual MFA device} in the \emph{IAM User Guide}.

See \url{https://paws-r.github.io/docs/iam/create_virtual_mfa_device.html} for full documentation.
}
\keyword{internal}
