% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_verify_software_token}
\alias{cognitoidentityprovider_verify_software_token}
\title{Use this API to register a user's entered time-based one-time password
(TOTP) code and mark the user's software token MFA status as "verified"
if successful}
\usage{
cognitoidentityprovider_verify_software_token(
  AccessToken = NULL,
  Session = NULL,
  UserCode,
  FriendlyDeviceName = NULL
)
}
\arguments{
\item{AccessToken}{A valid access token that Amazon Cognito issued to the user whose
software token you want to verify.}

\item{Session}{The session that should be passed both ways in challenge-response calls
to the service.}

\item{UserCode}{[required] The one- time password computed using the secret code returned by
\code{\link[=cognitoidentityprovider_associate_software_token]{associate_software_token}}.}

\item{FriendlyDeviceName}{The friendly device name.}
}
\description{
Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.

See \url{https://paws-r.github.io/docs/cognitoidentityprovider/verify_software_token.html} for full documentation.
}
\keyword{internal}
