% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_create_cluster}
\alias{cloudhsmv2_create_cluster}
\title{Creates a new AWS CloudHSM cluster}
\usage{
cloudhsmv2_create_cluster(
  BackupRetentionPolicy = NULL,
  HsmType,
  SourceBackupId = NULL,
  SubnetIds,
  TagList = NULL
)
}
\arguments{
\item{BackupRetentionPolicy}{A policy that defines how the service retains backups.}

\item{HsmType}{[required] The type of HSM to use in the cluster. Currently the only allowed value
is \code{hsm1.medium}.}

\item{SourceBackupId}{The identifier (ID) of the cluster backup to restore. Use this value to
restore the cluster from a backup instead of creating a new cluster. To
find the backup ID, use
\code{\link[=cloudhsmv2_describe_backups]{describe_backups}}.}

\item{SubnetIds}{[required] The identifiers (IDs) of the subnets where you are creating the cluster.
You must specify at least one subnet. If you specify multiple subnets,
they must meet the following criteria:
\itemize{
\item All subnets must be in the same virtual private cloud (VPC).
\item You can specify only one subnet per Availability Zone.
}}

\item{TagList}{Tags to apply to the CloudHSM cluster during creation.}
}
\description{
Creates a new AWS CloudHSM cluster.

See \url{https://paws-r.github.io/docs/cloudhsmv2/create_cluster.html} for full documentation.
}
\keyword{internal}
