% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_disassociate_web_acl}
\alias{wafregional_disassociate_web_acl}
\title{This is AWS WAF CLASSIC REGIONAL documentation}
\usage{
wafregional_disassociate_web_acl(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The ARN (Amazon Resource Name) of the resource from which the web ACL is
being removed, either an application load balancer or Amazon API Gateway
stage.

The ARN should be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\verb{arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> }
\item For an Amazon API Gateway stage:
\verb{arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> }
}}
}
\description{
This is \strong{AWS WAF Classic Regional} documentation. For more
information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\details{
\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Removes a web ACL from the specified resource, either an application
load balancer or Amazon API Gateway stage.
}
\section{Request syntax}{
\preformatted{svc$disassociate_web_acl(
  ResourceArn = "string"
)
}
}

\keyword{internal}
