% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_list_geo_match_sets}
\alias{waf_list_geo_match_sets}
\title{This is AWS WAF CLASSIC documentation}
\usage{
waf_list_geo_match_sets(NextMarker, Limit)
}
\arguments{
\item{NextMarker}{If you specify a value for \code{Limit} and you have more \code{GeoMatchSet}s than
the value of \code{Limit}, AWS WAF returns a \code{NextMarker} value in the
response that allows you to list another group of \code{GeoMatchSet} objects.
For the second and subsequent \code{ListGeoMatchSets} requests, specify the
value of \code{NextMarker} from the previous response to get information
about another batch of \code{GeoMatchSet} objects.}

\item{Limit}{Specifies the number of \code{GeoMatchSet} objects that you want AWS WAF to
return for this request. If you have more \code{GeoMatchSet} objects than the
number you specify for \code{Limit}, the response includes a \code{NextMarker}
value that you can use to get another batch of \code{GeoMatchSet} objects.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\details{
\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Returns an array of GeoMatchSetSummary objects in the response.
}
\section{Request syntax}{
\preformatted{svc$list_geo_match_sets(
  NextMarker = "string",
  Limit = 123
)
}
}

\keyword{internal}
