% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_create_members}
\alias{securityhub_create_members}
\title{Creates a member association in Security Hub between the specified
accounts and the account used to make the request, which is the master
account}
\usage{
securityhub_create_members(AccountDetails)
}
\arguments{
\item{AccountDetails}{The list of accounts to associate with the Security Hub master account.
For each account, the list includes the account ID and the email
address.}
}
\description{
Creates a member association in Security Hub between the specified
accounts and the account used to make the request, which is the master
account. To successfully create a member, you must use this action from
an account that already has Security Hub enabled. To enable Security
Hub, you can use the \verb{<a>EnableSecurityHub</a>} operation.
}
\details{
After you use \code{CreateMembers} to create member account associations in
Security Hub, you must use the \verb{<a>InviteMembers</a>} operation to
invite the accounts to enable Security Hub and become member accounts in
Security Hub.

If the account owner accepts the invitation, the account becomes a
member account in Security Hub. A permissions policy is added that
permits the master account to view the findings generated in the member
account. When Security Hub is enabled in the invited account, findings
start to be sent to both the member and master accounts.

To remove the association between the master and member accounts, use
the \verb{<a>DisassociateFromMasterAccount</a>} or
\verb{<a>DisassociateMembers</a>} operation.
}
\section{Request syntax}{
\preformatted{svc$create_members(
  AccountDetails = list(
    list(
      AccountId = "string",
      Email = "string"
    )
  )
)
}
}

\keyword{internal}
