% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_ssh_public_key}
\alias{iam_update_ssh_public_key}
\title{Sets the status of an IAM user's SSH public key to active or inactive}
\usage{
iam_update_ssh_public_key(UserName, SSHPublicKeyId, Status)
}
\arguments{
\item{UserName}{[required] The name of the IAM user associated with the SSH public key.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{SSHPublicKeyId}{[required] The unique identifier for the SSH public key.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters that
can consist of any upper or lowercased letter or digit.}

\item{Status}{[required] The status to assign to the SSH public key. \code{Active} means that the key
can be used for authentication with an AWS CodeCommit repository.
\code{Inactive} means that the key cannot be used.}
}
\description{
Sets the status of an IAM user\'s SSH public key to active or inactive.
SSH public keys that are inactive cannot be used for authentication.
This operation can be used to disable a user\'s SSH public key as part
of a key rotation work flow.
}
\details{
The SSH public key affected by this operation is used only for
authenticating the associated IAM user to an AWS CodeCommit repository.
For more information about using SSH keys to authenticate to an AWS
CodeCommit repository, see \href{https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html}{Set up AWS CodeCommit for SSH Connections}
in the \emph{AWS CodeCommit User Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_ssh_public_key(
  UserName = "string",
  SSHPublicKeyId = "string",
  Status = "Active"|"Inactive"
)
}
}

\keyword{internal}
