% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_rule}
\alias{wafregional_create_rule}
\title{Creates a Rule, which contains the IPSet objects, ByteMatchSet objects,
and other predicates that identify the requests that you want to block}
\usage{
wafregional_create_rule(Name, MetricName, ChangeToken, Tags)
}
\arguments{
\item{Name}{[required] A friendly name or description of the Rule. You can't change the name
of a \code{Rule} after you create it.}

\item{MetricName}{[required] A friendly name or description for the metrics for this \code{Rule}. The name
can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum
length 128 and minimum length one. It can't contain whitespace or
metric names reserved for AWS WAF, including "All" and
"Default\_Action." You can't change the name of the metric after you
create the \code{Rule}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Tags}{}
}
\description{
Creates a \code{Rule}, which contains the \code{IPSet} objects, \code{ByteMatchSet}
objects, and other predicates that identify the requests that you want
to block. If you add more than one predicate to a \code{Rule}, a request must
match all of the specifications to be allowed or blocked. For example,
suppose that you add the following to a \code{Rule}:
}
\details{
\itemize{
\item An \code{IPSet} that matches the IP address \code{192.0.2.44/32}
\item A \code{ByteMatchSet} that matches \code{BadBot} in the \code{User-Agent} header
}

You then add the \code{Rule} to a \code{WebACL} and specify that you want to
blocks requests that satisfy the \code{Rule}. For a request to be blocked, it
must come from the IP address 192.0.2.44 \emph{and} the \code{User-Agent} header
in the request must contain the value \code{BadBot}.

To create and configure a \code{Rule}, perform the following steps:
\enumerate{
\item Create and update the predicates that you want to include in the
\code{Rule}. For more information, see CreateByteMatchSet, CreateIPSet,
and CreateSqlInjectionMatchSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateRule} request.
\item Submit a \code{CreateRule} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateRule request.
\item Submit an \code{UpdateRule} request to specify the predicates that you
want to include in the \code{Rule}.
\item Create and update a \code{WebACL} that contains the \code{Rule}. For more
information, see CreateWebACL.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_rule(
  Name = "string",
  MetricName = "string",
  ChangeToken = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# The following example creates a rule named WAFByteHeaderRule.
\donttest{svc$create_rule(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  MetricName = "WAFByteHeaderRule",
  Name = "WAFByteHeaderRule"
)}

}
\keyword{internal}
