% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_disable_provider_for_user}
\alias{cognitoidentityprovider_admin_disable_provider_for_user}
\title{Disables the user from signing in with the specified external (SAML or
social) identity provider}
\usage{
cognitoidentityprovider_admin_disable_provider_for_user(UserPoolId,
  User)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{User}{[required] The user to be disabled.}
}
\description{
Disables the user from signing in with the specified external (SAML or
social) identity provider. If the user to disable is a Cognito User
Pools native username + password user, they are not permitted to use
their password to sign-in. If the user to disable is a linked external
IdP user, any link between that user and an existing user is removed.
The next time the external user (no longer attached to the previously
linked \code{DestinationUser}) signs in, they must create a new user account.
See .
}
\details{
This action is enabled only for admin access and requires developer
credentials.

The \code{ProviderName} must match the value specified when creating an IdP
for the pool.

To disable a native username + password user, the \code{ProviderName} value
must be \code{Cognito} and the \code{ProviderAttributeName} must be
\code{Cognito_Subject}, with the \code{ProviderAttributeValue} being the name that
is used in the user pool for the user.

The \code{ProviderAttributeName} must always be \code{Cognito_Subject} for social
identity providers. The \code{ProviderAttributeValue} must always be the
exact subject that was used when the user was originally linked as a
source user.

For de-linking a SAML identity, there are two scenarios. If the linked
identity has not yet been used to sign-in, the \code{ProviderAttributeName}
and \code{ProviderAttributeValue} must be the same values that were used for
the \code{SourceUser} when the identities were originally linked in the call.
(If the linking was done with \code{ProviderAttributeName} set to
\code{Cognito_Subject}, the same applies here). However, if the user has
already signed in, the \code{ProviderAttributeName} must be \code{Cognito_Subject}
and \code{ProviderAttributeValue} must be the subject of the SAML assertion.
}
\section{Request syntax}{
\preformatted{svc$admin_disable_provider_for_user(
  UserPoolId = "string",
  User = list(
    ProviderName = "string",
    ProviderAttributeName = "string",
    ProviderAttributeValue = "string"
  )
)
}
}

\keyword{internal}
