% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_tag_resource}
\alias{kms_tag_resource}
\title{Adds or edits tags for a customer master key (CMK)}
\usage{
kms_tag_resource(KeyId, Tags)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the CMK you are tagging.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{Tags}{[required] One or more tags. Each tag consists of a tag key and a tag value.}
}
\description{
Adds or edits tags for a customer master key (CMK). You cannot perform
this operation on a CMK in a different AWS account.
}
\details{
Each tag consists of a tag key and a tag value. Tag keys and tag values
are both required, but tag values can be empty (null) strings.

You can only use a tag key once for each CMK. If you use the tag key
again, AWS KMS replaces the current tag value with the specified value.

For information about the rules that apply to tag keys and tag values,
see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html}{User-Defined Tag Restrictions}
in the \emph{AWS Billing and Cost Management User Guide}.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  KeyId = "string",
  Tags = list(
    list(
      TagKey = "string",
      TagValue = "string"
    )
  )
)
}
}

\examples{
# The following example tags a CMK.
\donttest{svc$tag_resource(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  Tags = list(
    list(
      TagKey = "Purpose",
      TagValue = "Test"
    )
  )
)}

}
\keyword{internal}
