% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_respond_to_auth_challenge}
\alias{cognitoidentityprovider_respond_to_auth_challenge}
\title{Responds to the authentication challenge}
\usage{
cognitoidentityprovider_respond_to_auth_challenge(ClientId,
  ChallengeName, Session, ChallengeResponses, AnalyticsMetadata,
  UserContextData)
}
\arguments{
\item{ClientId}{[required] The app client ID.}

\item{ChallengeName}{[required] The challenge name. For more information, see .

\code{ADMIN_NO_SRP_AUTH} is not a valid value.}

\item{Session}{The session which should be passed both ways in challenge-response calls
to the service. If \code{InitiateAuth} or \code{RespondToAuthChallenge} API call
determines that the caller needs to go through another challenge, they
return a session with other challenge parameters. This session should be
passed as it is to the next \code{RespondToAuthChallenge} API call.}

\item{ChallengeResponses}{The challenge responses. These are inputs corresponding to the value of
\code{ChallengeName}, for example:
\itemize{
\item \code{SMS_MFA}: \code{SMS_MFA_CODE}, \code{USERNAME}, \code{SECRET_HASH} (if app client
is configured with client secret).
\item \code{PASSWORD_VERIFIER}: \code{PASSWORD_CLAIM_SIGNATURE},
\code{PASSWORD_CLAIM_SECRET_BLOCK}, \code{TIMESTAMP}, \code{USERNAME},
\code{SECRET_HASH} (if app client is configured with client secret).
\item \code{NEW_PASSWORD_REQUIRED}: \code{NEW_PASSWORD}, any other required
attributes, \code{USERNAME}, \code{SECRET_HASH} (if app client is configured
with client secret).
}}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{RespondToAuthChallenge} calls.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}
}
\description{
Responds to the authentication challenge.
}
\section{Request syntax}{
\preformatted{svc$respond_to_auth_challenge(
  ClientId = "string",
  ChallengeName = "SMS_MFA"|"SOFTWARE_TOKEN_MFA"|"SELECT_MFA_TYPE"|"MFA_SETUP"|"PASSWORD_VERIFIER"|"CUSTOM_CHALLENGE"|"DEVICE_SRP_AUTH"|"DEVICE_PASSWORD_VERIFIER"|"ADMIN_NO_SRP_AUTH"|"NEW_PASSWORD_REQUIRED",
  Session = "string",
  ChallengeResponses = list(
    "string"
  ),
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  UserContextData = list(
    EncodedData = "string"
  )
)
}
}

\keyword{internal}
