% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_issue_certificate}
\alias{acmpca_issue_certificate}
\title{Uses your private certificate authority (CA) to issue a client
certificate}
\usage{
acmpca_issue_certificate(CertificateAuthorityArn, Csr, SigningAlgorithm,
  TemplateArn, Validity, IdempotencyToken)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
CreateCertificateAuthority. This must be of the form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }}

\item{Csr}{[required] The certificate signing request (CSR) for the certificate you want to
issue. You can use the following OpenSSL command to create the CSR and a
2048 bit RSA private key.

\code{openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr}

If you have a configuration file, you can use the following OpenSSL
command. The \code{usr_cert} block in the configuration file contains your
X509 version 3 extensions.

\code{openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr}}

\item{SigningAlgorithm}{[required] The name of the algorithm that will be used to sign the certificate to
be issued.}

\item{TemplateArn}{Specifies a custom configuration template to use when issuing a
certificate. If this parameter is not provided, ACM Private CA defaults
to the \code{EndEntityCertificate/V1} template.

The following service-owned \code{TemplateArn} values are supported by ACM
Private CA:
\itemize{
\item arn:aws:acm-pca:::template/EndEntityCertificate/V1
\item arn:aws:acm-pca:::template/SubordinateCACertificate\_PathLen0/V1
\item arn:aws:acm-pca:::template/SubordinateCACertificate\_PathLen1/V1
\item arn:aws:acm-pca:::template/SubordinateCACertificate\_PathLen2/V1
\item arn:aws:acm-pca:::template/SubordinateCACertificate\_PathLen3/V1
\item arn:aws:acm-pca:::template/RootCACertificate/V1
}

For more information, see \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html}{Using Templates}.}

\item{Validity}{[required] The type of the validity period.}

\item{IdempotencyToken}{Custom string that can be used to distinguish between calls to the
\strong{IssueCertificate} action. Idempotency tokens time out after one hour.
Therefore, if you call \strong{IssueCertificate} multiple times with the same
idempotency token within 5 minutes, ACM Private CA recognizes that you
are requesting only one certificate and will issue only one. If you
change the idempotency token for each call, PCA recognizes that you are
requesting multiple certificates.}
}
\description{
Uses your private certificate authority (CA) to issue a client
certificate. This action returns the Amazon Resource Name (ARN) of the
certificate. You can retrieve the certificate by calling the
GetCertificate action and specifying the ARN.
}
\details{
You cannot use the ACM \strong{ListCertificateAuthorities} action to retrieve
the ARNs of the certificates that you issue by using ACM Private CA.
}
\section{Request syntax}{
\preformatted{svc$issue_certificate(
  CertificateAuthorityArn = "string",
  Csr = raw,
  SigningAlgorithm = "SHA256WITHECDSA"|"SHA384WITHECDSA"|"SHA512WITHECDSA"|"SHA256WITHRSA"|"SHA384WITHRSA"|"SHA512WITHRSA",
  TemplateArn = "string",
  Validity = list(
    Value = 123,
    Type = "END_DATE"|"ABSOLUTE"|"DAYS"|"MONTHS"|"YEARS"
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
