% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_resources}
\alias{ram_list_resources}
\title{Lists the resources that you added to a resource shares or the resources
that are shared with you}
\usage{
ram_list_resources(resourceOwner, principal, resourceType, resourceArns,
  resourceShareArns, nextToken, maxResults)
}
\arguments{
\item{resourceOwner}{[required] The type of owner.}

\item{principal}{The principal.}

\item{resourceType}{The resource type.

Valid values: \code{codebuild:Project} | \code{codebuild:ReportGroup} |
\code{ec2:CapacityReservation} | \code{ec2:DedicatedHost} | \code{ec2:Subnet} |
\code{ec2:TrafficMirrorTarget} | \code{ec2:TransitGateway} |
\code{imagebuilder:Component} | \code{imagebuilder:Image} |
\code{imagebuilder:ImageRecipe} | \code{license-manager:LicenseConfiguration} I
\code{resource-groups:Group} | \code{rds:Cluster} | \code{route53resolver:ResolverRule}}

\item{resourceArns}{The Amazon Resource Names (ARN) of the resources.}

\item{resourceShareArns}{The Amazon Resource Names (ARN) of the resource shares.}

\item{nextToken}{The token for the next page of results.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\value{
A list with the following syntax:\preformatted{list(
  resources = list(
    list(
      arn = "string",
      type = "string",
      resourceShareArn = "string",
      resourceGroupArn = "string",
      status = "AVAILABLE"|"ZONAL_RESOURCE_INACCESSIBLE"|"LIMIT_EXCEEDED"|"UNAVAILABLE"|"PENDING",
      statusMessage = "string",
      creationTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists the resources that you added to a resource shares or the resources
that are shared with you.
}
\section{Request syntax}{
\preformatted{svc$list_resources(
  resourceOwner = "SELF"|"OTHER-ACCOUNTS",
  principal = "string",
  resourceType = "string",
  resourceArns = list(
    "string"
  ),
  resourceShareArns = list(
    "string"
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
