% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_get_resource_shares}
\alias{ram_get_resource_shares}
\title{Gets the resource shares that you own or the resource shares that are
shared with you}
\usage{
ram_get_resource_shares(resourceShareArns, resourceShareStatus,
  resourceOwner, name, tagFilters, nextToken, maxResults)
}
\arguments{
\item{resourceShareArns}{The Amazon Resource Names (ARN) of the resource shares.}

\item{resourceShareStatus}{The status of the resource share.}

\item{resourceOwner}{[required] The type of owner.}

\item{name}{The name of the resource share.}

\item{tagFilters}{One or more tag filters.}

\item{nextToken}{The token for the next page of results.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\value{
A list with the following syntax:\preformatted{list(
  resourceShares = list(
    list(
      resourceShareArn = "string",
      name = "string",
      owningAccountId = "string",
      allowExternalPrincipals = TRUE|FALSE,
      status = "PENDING"|"ACTIVE"|"FAILED"|"DELETING"|"DELETED",
      statusMessage = "string",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      creationTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedTime = as.POSIXct(
        "2015-01-01"
      ),
      featureSet = "CREATED_FROM_POLICY"|"PROMOTING_TO_STANDARD"|"STANDARD"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Gets the resource shares that you own or the resource shares that are
shared with you.
}
\section{Request syntax}{
\preformatted{svc$get_resource_shares(
  resourceShareArns = list(
    "string"
  ),
  resourceShareStatus = "PENDING"|"ACTIVE"|"FAILED"|"DELETING"|"DELETED",
  resourceOwner = "SELF"|"OTHER-ACCOUNTS",
  name = "string",
  tagFilters = list(
    list(
      tagKey = "string",
      tagValues = list(
        "string"
      )
    )
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
