% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_create_object}
\alias{clouddirectory_create_object}
\title{Creates an object in a Directory}
\usage{
clouddirectory_create_object(DirectoryArn, SchemaFacets,
  ObjectAttributeList, ParentReference, LinkName)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory in
which the object will be created. For more information, see arns.}

\item{SchemaFacets}{[required] A list of schema facets to be associated with the object. Do not provide
minor version components. See SchemaFacet for details.}

\item{ObjectAttributeList}{The attribute map whose attribute ARN contains the key and attribute
value as the map value.}

\item{ParentReference}{If specified, the parent reference to which this object will be
attached.}

\item{LinkName}{The name of link that is used to attach this object to a parent.}
}
\value{
A list with the following syntax:\preformatted{list(
  ObjectIdentifier = "string"
)
}
}
\description{
Creates an object in a Directory. Additionally attaches the object to a
parent, if a parent reference and \code{LinkName} is specified. An object is
simply a collection of Facet attributes. You can also use this API call
to create a policy object, if the facet from which you create the object
is a policy facet.
}
\section{Request syntax}{
\preformatted{svc$create_object(
  DirectoryArn = "string",
  SchemaFacets = list(
    list(
      SchemaArn = "string",
      FacetName = "string"
    )
  ),
  ObjectAttributeList = list(
    list(
      Key = list(
        SchemaArn = "string",
        FacetName = "string",
        Name = "string"
      ),
      Value = list(
        StringValue = "string",
        BinaryValue = raw,
        BooleanValue = TRUE|FALSE,
        NumberValue = "string",
        DatetimeValue = as.POSIXct(
          "2015-01-01"
        )
      )
    )
  ),
  ParentReference = list(
    Selector = "string"
  ),
  LinkName = "string"
)
}
}

\keyword{internal}
