% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_describe_products}
\alias{securityhub_describe_products}
\title{Returns information about the available products that you can subscribe
to and integrate with Security Hub in order to consolidate findings}
\usage{
securityhub_describe_products(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{The token that is required for pagination. On your first call to the
\code{\link[=securityhub_describe_products]{describe_products}} operation, set the
value of this parameter to \code{NULL}.

For subsequent calls to the operation, to continue listing data, set the
value of this parameter to the value returned from the previous
response.}

\item{MaxResults}{The maximum number of results to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Products = list(
    list(
      ProductArn = "string",
      ProductName = "string",
      CompanyName = "string",
      Description = "string",
      Categories = list(
        "string"
      ),
      IntegrationTypes = list(
        "SEND_FINDINGS_TO_SECURITY_HUB"|"RECEIVE_FINDINGS_FROM_SECURITY_HUB"
      ),
      MarketplaceUrl = "string",
      ActivationUrl = "string",
      ProductSubscriptionResourcePolicy = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns information about the available products that you can subscribe
to and integrate with Security Hub in order to consolidate findings.
}
\section{Request syntax}{
\preformatted{svc$describe_products(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
