% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_stop_assessment_run}
\alias{inspector_stop_assessment_run}
\title{Stops the assessment run that is specified by the ARN of the assessment
run}
\usage{
inspector_stop_assessment_run(assessmentRunArn, stopAction)
}
\arguments{
\item{assessmentRunArn}{[required] The ARN of the assessment run that you want to stop.}

\item{stopAction}{An input option that can be set to either START\_EVALUATION or
SKIP\_EVALUATION. START\_EVALUATION (the default value), stops the AWS
agent from collecting data and begins the results evaluation and the
findings generation process. SKIP\_EVALUATION cancels the assessment run
immediately, after which no findings are generated.}
}
\description{
Stops the assessment run that is specified by the ARN of the assessment
run.
}
\section{Request syntax}{
\preformatted{svc$stop_assessment_run(
  assessmentRunArn = "string",
  stopAction = "START_EVALUATION"|"SKIP_EVALUATION"
)
}
}

\examples{
# Stops the assessment run that is specified by the ARN of the assessment
# run.
\donttest{svc$stop_assessment_run(
  assessmentRunArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-..."
)}

}
\keyword{internal}
