% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_describe_trusts}
\alias{directoryservice_describe_trusts}
\title{Obtains information about the trust relationships for this account}
\usage{
directoryservice_describe_trusts(DirectoryId, TrustIds, NextToken,
  Limit)
}
\arguments{
\item{DirectoryId}{The Directory ID of the AWS directory that is a part of the requested
trust relationship.}

\item{TrustIds}{A list of identifiers of the trust relationships for which to obtain the
information. If this member is null, all trust relationships that belong
to the current account are returned.

An empty list results in an \code{InvalidParameterException} being thrown.}

\item{NextToken}{The \emph{DescribeTrustsResult.NextToken} value from a previous call to
DescribeTrusts. Pass null if this is the first call.}

\item{Limit}{The maximum number of objects to return.}
}
\description{
Obtains information about the trust relationships for this account.
}
\details{
If no input parameters are provided, such as DirectoryId or TrustIds,
this request describes all the trust relationships belonging to the
account.
}
\section{Request syntax}{
\preformatted{svc$describe_trusts(
  DirectoryId = "string",
  TrustIds = list(
    "string"
  ),
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
