% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_user_pool_client}
\alias{cognitoidentityprovider_update_user_pool_client}
\title{Updates the specified user pool app client with the specified attributes}
\usage{
cognitoidentityprovider_update_user_pool_client(UserPoolId, ClientId,
  ClientName, RefreshTokenValidity, ReadAttributes, WriteAttributes,
  ExplicitAuthFlows, SupportedIdentityProviders, CallbackURLs, LogoutURLs,
  DefaultRedirectURI, AllowedOAuthFlows, AllowedOAuthScopes,
  AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to update the user
pool client.}

\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{ClientName}{The client name from the update user pool client request.}

\item{RefreshTokenValidity}{The time limit, in days, after which the refresh token is no longer
valid and cannot be used.}

\item{ReadAttributes}{The read-only attributes of the user pool.}

\item{WriteAttributes}{The writeable attributes of the user pool.}

\item{ExplicitAuthFlows}{Explicit authentication flows.}

\item{SupportedIdentityProviders}{A list of provider names for the identity providers that are supported
on this client.}

\item{CallbackURLs}{A list of allowed redirect (callback) URLs for the identity providers.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://tools.ietf.org/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{LogoutURLs}{A list of allowed logout URLs for the identity providers.}

\item{DefaultRedirectURI}{The default redirect URI. Must be in the \code{CallbackURLs} list.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://tools.ietf.org/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{AllowedOAuthFlows}{Set to \code{code} to initiate a code grant flow, which provides an
authorization code as the response. This code can be exchanged for
access tokens with the token endpoint.

Set to \code{token} to specify that the client should get the access token
(and, optionally, ID token, based on scopes) directly.}

\item{AllowedOAuthScopes}{A list of allowed \code{OAuth} scopes. Currently supported values are
\code{"phone"}, \code{"email"}, \code{"openid"}, and \code{"Cognito"}.}

\item{AllowedOAuthFlowsUserPoolClient}{Set to TRUE if the client is allowed to follow the OAuth protocol when
interacting with Cognito user pools.}

\item{AnalyticsConfiguration}{The Amazon Pinpoint analytics configuration for collecting metrics for
this user pool.}
}
\description{
Updates the specified user pool app client with the specified
attributes. If you don't provide a value for an attribute, it will be
set to the default value. You can get a list of the current user pool
app client settings with .
}
\section{Request syntax}{
\preformatted{svc$update_user_pool_client(
  UserPoolId = "string",
  ClientId = "string",
  ClientName = "string",
  RefreshTokenValidity = 123,
  ReadAttributes = list(
    "string"
  ),
  WriteAttributes = list(
    "string"
  ),
  ExplicitAuthFlows = list(
    "ADMIN_NO_SRP_AUTH"|"CUSTOM_AUTH_FLOW_ONLY"|"USER_PASSWORD_AUTH"
  ),
  SupportedIdentityProviders = list(
    "string"
  ),
  CallbackURLs = list(
    "string"
  ),
  LogoutURLs = list(
    "string"
  ),
  DefaultRedirectURI = "string",
  AllowedOAuthFlows = list(
    "code"|"implicit"|"client_credentials"
  ),
  AllowedOAuthScopes = list(
    "string"
  ),
  AllowedOAuthFlowsUserPoolClient = TRUE|FALSE,
  AnalyticsConfiguration = list(
    ApplicationId = "string",
    RoleArn = "string",
    ExternalId = "string",
    UserDataShared = TRUE|FALSE
  )
)
}
}

\keyword{internal}
