# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Route53 Recovery Readiness
#'
#' @description
#' Recovery readiness
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- route53recoveryreadiness(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- route53recoveryreadiness()
#' svc$create_cell(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=route53recoveryreadiness_create_cell]{create_cell} \tab Creates a cell in an account\cr
#'  \link[=route53recoveryreadiness_create_cross_account_authorization]{create_cross_account_authorization} \tab Creates a cross-account readiness authorization\cr
#'  \link[=route53recoveryreadiness_create_readiness_check]{create_readiness_check} \tab Creates a readiness check in an account\cr
#'  \link[=route53recoveryreadiness_create_recovery_group]{create_recovery_group} \tab Creates a recovery group in an account\cr
#'  \link[=route53recoveryreadiness_create_resource_set]{create_resource_set} \tab Creates a resource set\cr
#'  \link[=route53recoveryreadiness_delete_cell]{delete_cell} \tab Delete a cell\cr
#'  \link[=route53recoveryreadiness_delete_cross_account_authorization]{delete_cross_account_authorization} \tab Deletes cross account readiness authorization\cr
#'  \link[=route53recoveryreadiness_delete_readiness_check]{delete_readiness_check} \tab Deletes a readiness check\cr
#'  \link[=route53recoveryreadiness_delete_recovery_group]{delete_recovery_group} \tab Deletes a recovery group\cr
#'  \link[=route53recoveryreadiness_delete_resource_set]{delete_resource_set} \tab Deletes a resource set\cr
#'  \link[=route53recoveryreadiness_get_architecture_recommendations]{get_architecture_recommendations} \tab Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group\cr
#'  \link[=route53recoveryreadiness_get_cell]{get_cell} \tab Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs\cr
#'  \link[=route53recoveryreadiness_get_cell_readiness_summary]{get_cell_readiness_summary} \tab Gets readiness for a cell\cr
#'  \link[=route53recoveryreadiness_get_readiness_check]{get_readiness_check} \tab Gets details about a readiness check\cr
#'  \link[=route53recoveryreadiness_get_readiness_check_resource_status]{get_readiness_check_resource_status} \tab Gets individual readiness status for a readiness check\cr
#'  \link[=route53recoveryreadiness_get_readiness_check_status]{get_readiness_check_status} \tab Gets the readiness status for an individual readiness check\cr
#'  \link[=route53recoveryreadiness_get_recovery_group]{get_recovery_group} \tab Gets details about a recovery group, including a list of the cells that are included in it\cr
#'  \link[=route53recoveryreadiness_get_recovery_group_readiness_summary]{get_recovery_group_readiness_summary} \tab Displays a summary of information about a recovery group's readiness status\cr
#'  \link[=route53recoveryreadiness_get_resource_set]{get_resource_set} \tab Displays the details about a resource set, including a list of the resources in the set\cr
#'  \link[=route53recoveryreadiness_list_cells]{list_cells} \tab Lists the cells for an account\cr
#'  \link[=route53recoveryreadiness_list_cross_account_authorizations]{list_cross_account_authorizations} \tab Lists the cross-account readiness authorizations that are in place for an account\cr
#'  \link[=route53recoveryreadiness_list_readiness_checks]{list_readiness_checks} \tab Lists the readiness checks for an account\cr
#'  \link[=route53recoveryreadiness_list_recovery_groups]{list_recovery_groups} \tab Lists the recovery groups in an account\cr
#'  \link[=route53recoveryreadiness_list_resource_sets]{list_resource_sets} \tab Lists the resource sets in an account\cr
#'  \link[=route53recoveryreadiness_list_rules]{list_rules} \tab Lists all readiness rules, or lists the readiness rules for a specific resource type\cr
#'  \link[=route53recoveryreadiness_list_tags_for_resources]{list_tags_for_resources} \tab Lists the tags for a resource\cr
#'  \link[=route53recoveryreadiness_tag_resource]{tag_resource} \tab Adds a tag to a resource\cr
#'  \link[=route53recoveryreadiness_untag_resource]{untag_resource} \tab Removes a tag from a resource\cr
#'  \link[=route53recoveryreadiness_update_cell]{update_cell} \tab Updates a cell to replace the list of nested cells with a new list of nested cells\cr
#'  \link[=route53recoveryreadiness_update_readiness_check]{update_readiness_check} \tab Updates a readiness check\cr
#'  \link[=route53recoveryreadiness_update_recovery_group]{update_recovery_group} \tab Updates a recovery group\cr
#'  \link[=route53recoveryreadiness_update_resource_set]{update_resource_set} \tab Updates a resource set
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname route53recoveryreadiness
#' @export
route53recoveryreadiness <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .route53recoveryreadiness$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.route53recoveryreadiness <- list()

.route53recoveryreadiness$operations <- list()

.route53recoveryreadiness$metadata <- list(
  service_name = "route53recoveryreadiness",
  endpoints = list("*" = list(endpoint = "route53-recovery-readiness.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "route53-recovery-readiness.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "route53-recovery-readiness.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "route53-recovery-readiness.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Route53 Recovery Readiness",
  api_version = "2019-12-02",
  signing_name = "route53-recovery-readiness",
  json_version = "1.1",
  target_prefix = ""
)

.route53recoveryreadiness$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.route53recoveryreadiness$metadata, handlers, config)
}
