# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Backup Gateway
#'
#' @description
#' Backup gateway
#' 
#' Backup gateway connects Backup to your hypervisor, so you can create,
#' store, and restore backups of your virtual machines (VMs) anywhere,
#' whether on-premises or in the VMware Cloud (VMC) on Amazon Web Services.
#' 
#' Add on-premises resources by connecting to a hypervisor through a
#' gateway. Backup will automatically discover the resources in your
#' hypervisor.
#' 
#' Use Backup to assign virtual or on-premises resources to a backup plan,
#' or run on-demand backups. Once you have backed up your resources, you
#' can view them and restore them like any resource supported by Backup.
#' 
#' To download the Amazon Web Services software to get started, navigate to
#' the Backup console, choose **Gateways**, then choose **Create gateway**.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- backupgateway(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- backupgateway()
#' svc$associate_gateway_to_server(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=backupgateway_associate_gateway_to_server]{associate_gateway_to_server} \tab Associates a backup gateway with your server\cr
#'  \link[=backupgateway_create_gateway]{create_gateway} \tab Creates a backup gateway\cr
#'  \link[=backupgateway_delete_gateway]{delete_gateway} \tab Deletes a backup gateway\cr
#'  \link[=backupgateway_delete_hypervisor]{delete_hypervisor} \tab Deletes a hypervisor\cr
#'  \link[=backupgateway_disassociate_gateway_from_server]{disassociate_gateway_from_server} \tab Disassociates a backup gateway from the specified server\cr
#'  \link[=backupgateway_get_gateway]{get_gateway} \tab By providing the ARN (Amazon Resource Name), this API returns the gateway\cr
#'  \link[=backupgateway_import_hypervisor_configuration]{import_hypervisor_configuration} \tab Connect to a hypervisor by importing its configuration\cr
#'  \link[=backupgateway_list_gateways]{list_gateways} \tab Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region\cr
#'  \link[=backupgateway_list_hypervisors]{list_hypervisors} \tab Lists your hypervisors\cr
#'  \link[=backupgateway_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags applied to the resource identified by its Amazon Resource Name (ARN)\cr
#'  \link[=backupgateway_list_virtual_machines]{list_virtual_machines} \tab Lists your virtual machines\cr
#'  \link[=backupgateway_put_maintenance_start_time]{put_maintenance_start_time} \tab Set the maintenance start time for a gateway\cr
#'  \link[=backupgateway_tag_resource]{tag_resource} \tab Tag the resource\cr
#'  \link[=backupgateway_test_hypervisor_configuration]{test_hypervisor_configuration} \tab Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources\cr
#'  \link[=backupgateway_untag_resource]{untag_resource} \tab Removes tags from the resource\cr
#'  \link[=backupgateway_update_gateway_information]{update_gateway_information} \tab Updates a gateway's name\cr
#'  \link[=backupgateway_update_gateway_software_now]{update_gateway_software_now} \tab Updates the gateway virtual machine (VM) software\cr
#'  \link[=backupgateway_update_hypervisor]{update_hypervisor} \tab Updates a hypervisor metadata, including its host, username, and password
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname backupgateway
#' @export
backupgateway <- function(config = list()) {
  svc <- .backupgateway$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.backupgateway <- list()

.backupgateway$operations <- list()

.backupgateway$metadata <- list(
  service_name = "backupgateway",
  endpoints = list("*" = list(endpoint = "backup-gateway.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "backup-gateway.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "backup-gateway.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "backup-gateway.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Backup Gateway",
  api_version = "2021-01-01",
  signing_name = "backup-gateway",
  json_version = "1.0",
  target_prefix = "BackupOnPremises_v20210101"
)

.backupgateway$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.backupgateway$metadata, handlers, config)
}
