% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_list_virtual_services}
\alias{appmesh_list_virtual_services}
\title{Returns a list of existing virtual services in a service mesh}
\usage{
appmesh_list_virtual_services(limit, meshName, nextToken)
}
\arguments{
\item{limit}{The maximum number of results returned by \code{ListVirtualServices} in
paginated output. When you use this parameter, \code{ListVirtualServices}
returns only \code{limit} results in a single page along with a \code{nextToken}
response element. You can see the remaining results of the initial
request by sending another \code{ListVirtualServices} request with the
returned \code{nextToken} value. This value can be between 1 and 100. If you
don\'t use this parameter, \code{ListVirtualServices} returns up to 100
results and a \code{nextToken} value if applicable.}

\item{meshName}{[required] The name of the service mesh to list virtual services in.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{ListVirtualServices} request where \code{limit} was used and the results
exceeded the value of that parameter. Pagination continues from the end
of the previous results that returned the \code{nextToken} value.}
}
\description{
Returns a list of existing virtual services in a service mesh.
}
\section{Request syntax}{
\preformatted{svc$list_virtual_services(
  limit = 123,
  meshName = "string",
  nextToken = "string"
)
}
}

\keyword{internal}
