% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_describe_instance_health}
\alias{elb_describe_instance_health}
\title{Describes the state of the specified instances with respect to the
specified load balancer}
\usage{
elb_describe_instance_health(LoadBalancerName, Instances)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{Instances}{The IDs of the instances.}
}
\description{
Describes the state of the specified instances with respect to the
specified load balancer. If no instances are specified, the call
describes the state of all instances that are currently registered with
the load balancer. If instances are specified, their state is returned
even if they are no longer registered with the load balancer. The state
of terminated instances is not returned.
}
\section{Request syntax}{
\preformatted{svc$describe_instance_health(
  LoadBalancerName = "string",
  Instances = list(
    list(
      InstanceId = "string"
    )
  )
)
}
}

\examples{
# This example describes the health of the instances for the specified
# load balancer.
\donttest{svc$describe_instance_health(
  LoadBalancerName = "my-load-balancer"
)}

}
\keyword{internal}
