% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_get_deployment}
\alias{apigateway_get_deployment}
\title{Gets information about a Deployment resource}
\usage{
apigateway_get_deployment(restApiId, deploymentId, embed)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{deploymentId}{[required] [Required] The identifier of the Deployment resource to get
information about.}

\item{embed}{A query parameter to retrieve the specified embedded resources of the
returned Deployment resource in the response. In a REST API call, this
\code{embed} parameter value is a list of comma-separated strings, as in
\code{GET /restapis/\{restapi_id\}/deployments/\{deployment_id\}?embed=var1,var2}.
The SDK and other platform-dependent libraries might use a different
format for the list. Currently, this request supports only retrieval of
the embedded API summary this way. Hence, the parameter value must be a
single-valued list containing only the \code{"apisummary"} string. For
example,
\code{GET /restapis/\{restapi_id\}/deployments/\{deployment_id\}?embed=apisummary}.}
}
\description{
Gets information about a Deployment resource.
}
\section{Request syntax}{
\preformatted{svc$get_deployment(
  restApiId = "string",
  deploymentId = "string",
  embed = list(
    "string"
  )
)
}
}

\keyword{internal}
