% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_update_service}
\alias{servicediscovery_update_service}
\title{Submits a request to perform the following operations:}
\usage{
servicediscovery_update_service(Id, Service)
}
\arguments{
\item{Id}{[required] The ID of the service that you want to update.}

\item{Service}{[required] A complex type that contains the new settings for the service.}
}
\value{
A list with the following syntax:\preformatted{list(
  OperationId = "string"
)
}
}
\description{
Submits a request to perform the following operations:
\itemize{
\item Update the TTL setting for existing \code{DnsRecords} configurations
\item Add, update, or delete \code{HealthCheckConfig} for a specified service

You can't add, update, or delete a \code{HealthCheckCustomConfig}
configuration.
}

For public and private DNS namespaces, note the following:
\itemize{
\item If you omit any existing \code{DnsRecords} or \code{HealthCheckConfig}
configurations from an
\code{\link[=servicediscovery_update_service]{update_service}} request, the
configurations are deleted from the service.
\item If you omit an existing \code{HealthCheckCustomConfig} configuration from
an \code{\link[=servicediscovery_update_service]{update_service}} request, the
configuration is not deleted from the service.
}

When you update settings for a service, AWS Cloud Map also updates the
corresponding settings in all the records and health checks that were
created by using the specified service.
}
\section{Request syntax}{
\preformatted{svc$update_service(
  Id = "string",
  Service = list(
    Description = "string",
    DnsConfig = list(
      DnsRecords = list(
        list(
          Type = "SRV"|"A"|"AAAA"|"CNAME",
          TTL = 123
        )
      )
    ),
    HealthCheckConfig = list(
      Type = "HTTP"|"HTTPS"|"TCP",
      ResourcePath = "string",
      FailureThreshold = 123
    )
  )
)
}
}

\examples{
\dontrun{
# This example submits a request to replace the DnsConfig and
# HealthCheckConfig settings of a specified service.
svc$update_service(
  Id = "srv-e4anhexample0004",
  Service = list(
    DnsConfig = list(
      DnsRecords = list(
        list(
          TTL = 60L,
          Type = "A"
        )
      )
    ),
    HealthCheckConfig = list(
      FailureThreshold = 2L,
      ResourcePath = "/",
      Type = "HTTP"
    )
  )
)
}

}
\keyword{internal}
