% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_delete_direct_connect_gateway_association_proposal}
\alias{directconnect_delete_direct_connect_gateway_association_proposal}
\title{Deletes the association proposal request between the specified Direct
Connect gateway and virtual private gateway or transit gateway}
\usage{
directconnect_delete_direct_connect_gateway_association_proposal(
  proposalId)
}
\arguments{
\item{proposalId}{[required] The ID of the proposal.}
}
\value{
A list with the following syntax:\preformatted{list(
  directConnectGatewayAssociationProposal = list(
    proposalId = "string",
    directConnectGatewayId = "string",
    directConnectGatewayOwnerAccount = "string",
    proposalState = "requested"|"accepted"|"deleted",
    associatedGateway = list(
      id = "string",
      type = "virtualPrivateGateway"|"transitGateway",
      ownerAccount = "string",
      region = "string"
    ),
    existingAllowedPrefixesToDirectConnectGateway = list(
      list(
        cidr = "string"
      )
    ),
    requestedAllowedPrefixesToDirectConnectGateway = list(
      list(
        cidr = "string"
      )
    )
  )
)
}
}
\description{
Deletes the association proposal request between the specified Direct
Connect gateway and virtual private gateway or transit gateway.
}
\section{Request syntax}{
\preformatted{svc$delete_direct_connect_gateway_association_proposal(
  proposalId = "string"
)
}
}

\keyword{internal}
