% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_accept_domain_transfer_from_another_aws_account}
\alias{route53domains_accept_domain_transfer_from_another_aws_account}
\title{Accepts the transfer of a domain from another AWS account to the current
AWS account}
\usage{
route53domains_accept_domain_transfer_from_another_aws_account(
  DomainName, Password)
}
\arguments{
\item{DomainName}{[required] The name of the domain that was specified when another AWS account
submitted a
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html}{TransferDomainToAnotherAwsAccount}
request.}

\item{Password}{[required] The password that was returned by the
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html}{TransferDomainToAnotherAwsAccount}
request.}
}
\description{
Accepts the transfer of a domain from another AWS account to the current
AWS account. You initiate a transfer between AWS accounts using
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html}{TransferDomainToAnotherAwsAccount}.

Use either
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html}{ListOperations}
or
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html}{GetOperationDetail}
to determine whether the operation succeeded.
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html}{GetOperationDetail}
provides additional information, for example,
\verb{Domain Transfer from Aws Account 111122223333 has been cancelled}.
}
\section{Request syntax}{
\preformatted{svc$accept_domain_transfer_from_another_aws_account(
  DomainName = "string",
  Password = "string"
)
}
}

\keyword{internal}
