% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_key_signing_key}
\alias{route53_create_key_signing_key}
\title{Creates a new key signing key (KSK) associated with a hosted zone}
\usage{
route53_create_key_signing_key(CallerReference, HostedZoneId,
  KeyManagementServiceArn, Name, Status)
}
\arguments{
\item{CallerReference}{[required] A unique string that identifies the request.}

\item{HostedZoneId}{[required] The unique string (ID) used to identify a hosted zone.}

\item{KeyManagementServiceArn}{[required] The Amazon resource name (ARN) for a customer managed key (CMK) in AWS
Key Management Service (KMS). The \code{KeyManagementServiceArn} must be
unique for each key signing key (KSK) in a single hosted zone. To see an
example of \code{KeyManagementServiceArn} that grants the correct permissions
for DNSSEC, scroll down to \strong{Example}.

You must configure the CMK as follows:
\subsection{Status}{

Enabled
}

\subsection{Key spec}{

ECC\\_NIST\\_P256
}

\subsection{Key usage}{

Sign and verify
}

\subsection{Key policy}{

The key policy must give permission for the following actions:
\itemize{
\item DescribeKey
\item GetPublicKey
\item Sign
}

The key policy must also include the Amazon Route 53 service in the
principal for your account. Specify the following:
\itemize{
\item \code{"Service": "api-service.dnssec.route53.aws.internal"}
}

For more information about working with CMK in KMS, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html}{AWS Key Management Service concepts}.
}}

\item{Name}{[required] An alphanumeric string used to identify a key signing key (KSK). \code{Name}
must be unique for each key signing key in the same hosted zone.}

\item{Status}{[required] A string specifying the initial status of the key signing key (KSK). You
can set the value to \code{ACTIVE} or \code{INACTIVE}.}
}
\description{
Creates a new key signing key (KSK) associated with a hosted zone. You
can only have two KSKs per hosted zone.
}
\section{Request syntax}{
\preformatted{svc$create_key_signing_key(
  CallerReference = "string",
  HostedZoneId = "string",
  KeyManagementServiceArn = "string",
  Name = "string",
  Status = "string"
)
}
}

\keyword{internal}
