# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Managed Grafana
#'
#' @description
#' Amazon Managed Grafana is a fully managed and secure data visualization
#' service that you can use to instantly query, correlate, and visualize
#' operational metrics, logs, and traces from multiple sources. Amazon
#' Managed Grafana makes it easy to deploy, operate, and scale Grafana, a
#' widely deployed data visualization tool that is popular for its
#' extensible data support.
#' 
#' With Amazon Managed Grafana, you create logically isolated Grafana
#' servers called *workspaces*. In a workspace, you can create Grafana
#' dashboards and visualizations to analyze your metrics, logs, and traces
#' without having to build, package, or deploy any hardware to run Grafana
#' servers.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- managedgrafana(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- managedgrafana()
#' svc$associate_license(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=managedgrafana_associate_license]{associate_license} \tab Assigns a Grafana Enterprise license to a workspace\cr
#'  \link[=managedgrafana_create_workspace]{create_workspace} \tab Creates a workspace\cr
#'  \link[=managedgrafana_create_workspace_api_key]{create_workspace_api_key} \tab Creates a Grafana API key for the workspace\cr
#'  \link[=managedgrafana_create_workspace_service_account]{create_workspace_service_account} \tab Creates a service account for the workspace\cr
#'  \link[=managedgrafana_create_workspace_service_account_token]{create_workspace_service_account_token} \tab Creates a token that can be used to authenticate and authorize Grafana HTTP API operations for the given workspace service account\cr
#'  \link[=managedgrafana_delete_workspace]{delete_workspace} \tab Deletes an Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_delete_workspace_api_key]{delete_workspace_api_key} \tab Deletes a Grafana API key for the workspace\cr
#'  \link[=managedgrafana_delete_workspace_service_account]{delete_workspace_service_account} \tab Deletes a workspace service account from the workspace\cr
#'  \link[=managedgrafana_delete_workspace_service_account_token]{delete_workspace_service_account_token} \tab Deletes a token for the workspace service account\cr
#'  \link[=managedgrafana_describe_workspace]{describe_workspace} \tab Displays information about one Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_describe_workspace_authentication]{describe_workspace_authentication} \tab Displays information about the authentication methods used in one Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_describe_workspace_configuration]{describe_workspace_configuration} \tab Gets the current configuration string for the given workspace\cr
#'  \link[=managedgrafana_disassociate_license]{disassociate_license} \tab Removes the Grafana Enterprise license from a workspace\cr
#'  \link[=managedgrafana_list_permissions]{list_permissions} \tab Lists the users and groups who have the Grafana Admin and Editor roles in this workspace\cr
#'  \link[=managedgrafana_list_tags_for_resource]{list_tags_for_resource} \tab The ListTagsForResource operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the resourceArn\cr
#'  \link[=managedgrafana_list_versions]{list_versions} \tab Lists available versions of Grafana\cr
#'  \link[=managedgrafana_list_workspaces]{list_workspaces} \tab Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace\cr
#'  \link[=managedgrafana_list_workspace_service_accounts]{list_workspace_service_accounts} \tab Returns a list of service accounts for a workspace\cr
#'  \link[=managedgrafana_list_workspace_service_account_tokens]{list_workspace_service_account_tokens} \tab Returns a list of tokens for a workspace service account\cr
#'  \link[=managedgrafana_tag_resource]{tag_resource} \tab The TagResource operation associates tags with an Amazon Managed Grafana resource\cr
#'  \link[=managedgrafana_untag_resource]{untag_resource} \tab The UntagResource operation removes the association of the tag with the Amazon Managed Grafana resource\cr
#'  \link[=managedgrafana_update_permissions]{update_permissions} \tab Updates which users in a workspace have the Grafana Admin or Editor roles\cr
#'  \link[=managedgrafana_update_workspace]{update_workspace} \tab Modifies an existing Amazon Managed Grafana workspace\cr
#'  \link[=managedgrafana_update_workspace_authentication]{update_workspace_authentication} \tab Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML\cr
#'  \link[=managedgrafana_update_workspace_configuration]{update_workspace_configuration} \tab Updates the configuration string for the given workspace
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname managedgrafana
#' @export
managedgrafana <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .managedgrafana$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.managedgrafana <- list()

.managedgrafana$operations <- list()

.managedgrafana$metadata <- list(
  service_name = "managedgrafana",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "grafana.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "grafana.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "grafana.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "grafana.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "grafana.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "grafana.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "grafana.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "grafana",
  api_version = "2020-08-18",
  signing_name = "grafana",
  json_version = "1.1",
  target_prefix = ""
)

.managedgrafana$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.managedgrafana$metadata, handlers, config, op)
}
