% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prometheusservice_operations.R
\name{prometheusservice_list_workspaces}
\alias{prometheusservice_list_workspaces}
\title{Lists all of the Amazon Managed Service for Prometheus workspaces in
your account}
\usage{
prometheusservice_list_workspaces(
  alias = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{alias}{If this is included, it filters the results to only the workspaces with
names that start with the value that you specify here.

Amazon Managed Service for Prometheus will automatically strip any blank
spaces from the beginning and end of the alias that you specify.}

\item{maxResults}{The maximum number of workspaces to return per request. The default is
100.}

\item{nextToken}{The token for the next set of items to return. You receive this token
from a previous call, and use it to get the next page of results. The
other parameters must be the same as the initial call.

For example, if your initial request has \code{maxResults} of 10, and there
are 12 workspaces to return, then your initial request will return 10
and a \code{nextToken}. Using the next token in a subsequent call will return
the remaining 2 workspaces.}
}
\description{
Lists all of the Amazon Managed Service for Prometheus workspaces in your account. This includes workspaces being created or deleted.

See \url{https://www.paws-r-sdk.com/docs/prometheusservice_list_workspaces/} for full documentation.
}
\keyword{internal}
